package com.artfess.device.base.model;

import com.artfess.base.entity.BaseTreeModel;
import com.artfess.base.model.Tree;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 设备安装区域信息 例如：XX划片区域-->XX街道-->XX道路-->XX组团-->监测点
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
@Data
@ApiModel(value="DeviceBaseArea对象", description="设备安装区域信息 例如：XX划片区域-->XX街道-->XX道路-->XX组团-->监测点")
public class DeviceBaseArea extends BaseTreeModel<DeviceBaseArea> implements Tree {

    private static final long serialVersionUID = 1L;

    @NotBlank(message = "请填写区域简称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "区域简称")
    @TableField("SHORT_NAME_")
    private String shortName;

    @NotBlank(message = "请选择区域类型",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "区域类型（1：区域，2：街道，3：道路，4：组团，5：监测点）")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "创建人ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_by_", fill= FieldFill.INSERT, select=false)
    private String createBy;

    @ApiModelProperty(value = "创建时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="create_time_", fill=FieldFill.INSERT, select=true)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="update_by_", fill= FieldFill.UPDATE, select=false)
    private String updateBy;

    @ApiModelProperty(value = "更新时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="update_time_", fill= FieldFill.UPDATE, select=false)
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @TableField(exist=false)
    protected List<DeviceBaseArea> children = new ArrayList<DeviceBaseArea>();

    @Override
    public String getText() {
        return null;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List list) {
        this.children = list;
    }

    @Override
    public void setIsParent(String isParent) {
        this.parentId = parentId;
    }
}
