package com.artfess.device.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.device.base.dao.DeviceProductWarnConfDao;
import com.artfess.device.base.dao.DeviceProductWarnConfDetailsDao;
import com.artfess.device.base.manager.DeviceProductWarnConfManager;
import com.artfess.device.base.model.DeviceProductWarnConf;
import com.artfess.device.base.model.DeviceProductWarnConfDetails;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * 产品告警配置 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Service
public class DeviceProductWarnConfManagerImpl extends BaseManagerImpl<DeviceProductWarnConfDao, DeviceProductWarnConf> implements DeviceProductWarnConfManager {

    @Resource
    private DeviceProductWarnConfDetailsDao deviceProductWarnConfDetailsDao;

    @Override
    public DeviceProductWarnConf findById(String id) {
        DeviceProductWarnConf deviceProductWarnConf = this.baseMapper.selectById(id);
        if(null == deviceProductWarnConf) {
            return null;
        }
        QueryWrapper<DeviceProductWarnConfDetails> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("product_warn_conf_id_", id);
        List<DeviceProductWarnConfDetails> deviceProductWarnConfDetails = deviceProductWarnConfDetailsDao.selectList(queryWrapper);
        deviceProductWarnConf.setList(deviceProductWarnConfDetails);
        return deviceProductWarnConf;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(DeviceProductWarnConf t) {
        this.vaild(t);
        int i = this.baseMapper.updateById(t);
        if(i > 0){
            processDetails(t.getId(), t.getList());
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean saveInfo(DeviceProductWarnConf t) {
        this.vaild(t);
        int i = this.baseMapper.insert(t);
        if(i > 0){
            processDetails(t.getId(), t.getList());
            return true;
        }
        return false;
    }

    @Override
    public List<DeviceProductWarnConf> findByParams(DeviceProductWarnConf conf) {
        QueryWrapper<DeviceProductWarnConf> queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(conf.getProductId())){
            queryWrapper.like("PRODUCT_ID_", conf.getProductId());
        }

        if(StringUtils.isNotBlank(conf.getWarnName())){
            queryWrapper.like("WARN_NAME_", conf.getWarnName());
        }

        queryWrapper.orderByDesc("CREATE_TIME_");
        return this.baseMapper.selectList(queryWrapper);
    }

    private void processDetails(String id, List<DeviceProductWarnConfDetails> list) {

        QueryWrapper<DeviceProductWarnConfDetails> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("product_warn_conf_id_", id);
        this.deviceProductWarnConfDetailsDao.delete(queryWrapper);

        list.forEach(details -> {
            details.setProductWarnConfId(id);
            this.deviceProductWarnConfDetailsDao.insert(details);
        });
    }

    public void vaild(DeviceProductWarnConf t) {
        QueryWrapper<DeviceProductWarnConf> queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(t.getId())) {
            queryWrapper.ne("id_", t.getId());
        }
        queryWrapper.eq("warn_name_", t.getWarnName()).eq("product_id_",t.getProductId());
        List<DeviceProductWarnConf> properties = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(properties)) {
            throw new IllegalArgumentException("告警名称已重复，请重新输入");
        }
    }
}
