package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.device.base.dao.DeviceBaseCompanyDao;
import com.artfess.device.base.manager.DeviceBaseCompanyManager;
import com.artfess.device.base.model.DeviceBaseCompany;
import com.artfess.device.base.vo.CompanyAndUserVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 对单位（管理单位、运维单位、设备厂商、供应商）信息进行管理 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
@Service
public class DeviceBaseCompanyManagerImpl extends BaseManagerImpl<DeviceBaseCompanyDao, DeviceBaseCompany> implements DeviceBaseCompanyManager {

    @Override
    public List<DeviceBaseCompany> findAll(DeviceBaseCompany company) {
        QueryWrapper<DeviceBaseCompany> queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(company.getCompanyCode())){
            queryWrapper.like("COMPANY_CODE_", company.getCompanyCode());
        }

        if(StringUtils.isNotBlank(company.getCompanyName())){
            queryWrapper.like("COMPANY_NAME_", company.getCompanyName());
        }

        if(StringUtils.isNotBlank(company.getCompanyType())){
            queryWrapper.like("COMPANY_TYPE_", company.getCompanyType());
        }

        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByAsc("sn_");
        return this.baseMapper.selectList(queryWrapper);
    }

    @Override
    public List<CompanyAndUserVo> getCompanyAndUser(DeviceBaseCompany company) {

        List<CompanyAndUserVo> list = this.baseMapper.getCompanyAndUser(company);

        List<CompanyAndUserVo> tree = BeanUtils.listToTree(list);
        return tree;
    }
}
