package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.device.base.model.DeviceVideoPoint;
import com.artfess.device.base.model.DeviceVideoPointExtend;

import java.util.List;

/**
 * 视频点位信息表（DEVICE_VIDEO_POINT） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-19
 */
public interface DeviceVideoPointManager extends BaseManager<DeviceVideoPoint> {

    void deleteZoneRes(String zoneCode);

    /**
     * 修改点位扩展信息
     * @param t
     * @return
     */
    String updateInfo(DeviceVideoPointExtend t);

    /**
     * 根据视频点位编号获取点位信息
     * @param code
     * @return
     */
    DeviceVideoPoint findByCode(String code);

    /**
     * @Description: 修改摄像头状态
     * @param deviceCode 摄像头编码
     * @param status  状态（-1：报废，1：正常、2：故障、3:报警、9：其他）
     * @Return: java.lang.Boolean
     * @Author: chens
     * @Date: 2022/9/13 20:28
     */
    Boolean updateVideoStatus(String deviceCode, String status);

    /**
     * 根据编码查询华智设备的播放URL
     * @param code 设备编码
     * @param module 视频模式(1:RTSP,2:RTMP,3:HLS,4:HLS_SSL,5:HTTP FLV,6:HTTPS FLV,7:WS FLV,8:WSS FLV)
     * @param refresh 是否刷新token
     * @return 视频url地址
     */
    String getZGVideoUri(String code,Integer module,boolean refresh);

    /**
     * 同步紫光华智视频点位信息
     * @param refresh 是否刷新token
     * @Return: voidv
     * @Author: chens
     * @Date: 2022/9/9 18:28
     */
    Integer asycZGVideoPoint(boolean refresh);

    /**
     * 同步紫光华智视频目录信息
     * @param refresh 是否刷新token
     * @Return: voidv
     * @Author: chens
     * @Date: 2022/9/9 18:28
     */
    void asycZGZone(boolean refresh);

    /**
     * 同步紫光华智视频点位信息
     * @param refresh 是否刷新token
     * @Return: voidv
     * @Author: chens
     * @Date: 2022/9/9 18:28
     */
    List<DeviceVideoPoint> asycZGcameras(boolean refresh);
}
