package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.model.DeviceBaseSpare;

import java.util.List;

/**
 * 对备品件进行管理 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
public interface DeviceBaseSpareManager extends BaseManager<DeviceBaseSpare> {

    /**
     * 备品件分页查询
     * @param queryFilter
     * @return
     */
    PageList<DeviceBaseSpare> findByPage(QueryFilter<DeviceBaseSpare> queryFilter);

    /**
     * 根据备品库id获取相关备品件列表
     * @param houseIds
     * @return
     */
    List<DeviceBaseSpare> findByHouseIds(List<String> houseIds);

}
