package com.artfess.device.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.device.base.manager.DeviceProductWarnConfManager;
import com.artfess.device.base.model.DeviceProductWarnConf;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 产品告警配置 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Slf4j
@RestController
@Api(tags = "设施设备-产品告警配置")
@RequestMapping("/device/product/warnConf/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceProductWarnConfController extends BaseController<DeviceProductWarnConfManager, DeviceProductWarnConf> {

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) DeviceProductWarnConf t) {
        boolean result = baseService.saveInfo(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @Override
    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({UpdateGroup.class})  DeviceProductWarnConf t) {
        boolean result = baseService.updateInfo(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>();
    }

    @Override
    @GetMapping("/{id}")
    @ApiOperation("根据id查询实体")
    public DeviceProductWarnConf getById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        return baseService.findById(id);
    }


    @PostMapping(value="/findByParams", produces={"application/json; charset=utf-8" })
    @ApiOperation("根据查询条件获取产品告警配置列表")
    public List<DeviceProductWarnConf> findByParams(@ApiParam(name="model", value="查询条件") @RequestBody DeviceProductWarnConf conf) {
        return baseService.findByParams(conf);
    }
}
