/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.transport.NameResolverProvider;
import reactor.netty.transport.TransportConfig;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public class TcpResources
implements ConnectionProvider,
LoopResources {
    final LoopResources defaultLoops;
    final ConnectionProvider defaultProvider;
    final AtomicReference<AddressResolverGroup<?>> defaultResolver;
    static final NameResolverProvider DEFAULT_NAME_RESOLVER_PROVIDER;
    static final Logger log;
    static final BiFunction<LoopResources, ConnectionProvider, TcpResources> ON_TCP_NEW;
    static final AtomicReference<TcpResources> tcpResources;

    public static void disposeLoopsAndConnections() {
        TcpResources resources2 = tcpResources.getAndSet(null);
        if (resources2 != null) {
            resources2._dispose();
        }
    }

    public static Mono<Void> disposeLoopsAndConnectionsLater() {
        return TcpResources.disposeLoopsAndConnectionsLater(Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_QUIET_PERIOD), Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_TIMEOUT));
    }

    public static Mono<Void> disposeLoopsAndConnectionsLater(Duration quietPeriod, Duration timeout) {
        Objects.requireNonNull(quietPeriod, "quietPeriod");
        Objects.requireNonNull(timeout, "timeout");
        return Mono.defer(() -> {
            TcpResources resources2 = tcpResources.getAndSet(null);
            if (resources2 != null) {
                return resources2._disposeLater(quietPeriod, timeout);
            }
            return Mono.empty();
        });
    }

    public static TcpResources get() {
        return TcpResources.getOrCreate(tcpResources, null, null, ON_TCP_NEW, "tcp");
    }

    public static TcpResources reset() {
        TcpResources.disposeLoopsAndConnections();
        return TcpResources.getOrCreate(tcpResources, null, null, ON_TCP_NEW, "tcp");
    }

    public static TcpResources set(ConnectionProvider provider) {
        return TcpResources.getOrCreate(tcpResources, null, provider, ON_TCP_NEW, "tcp");
    }

    public static TcpResources set(LoopResources loops) {
        return TcpResources.getOrCreate(tcpResources, loops, null, ON_TCP_NEW, "tcp");
    }

    protected TcpResources(LoopResources defaultLoops, ConnectionProvider defaultProvider) {
        this.defaultLoops = defaultLoops;
        this.defaultProvider = defaultProvider;
        this.defaultResolver = new AtomicReference();
    }

    @Override
    public Mono<? extends Connection> acquire(TransportConfig config, ConnectionObserver observer, @Nullable Supplier<? extends SocketAddress> remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        Objects.requireNonNull(config, "config");
        Objects.requireNonNull(observer, "observer");
        return this.defaultProvider.acquire(config, observer, remoteAddress, resolverGroup);
    }

    @Override
    public boolean daemon() {
        return this.defaultLoops.daemon();
    }

    @Override
    public void dispose() {
    }

    @Override
    public Mono<Void> disposeLater() {
        return Mono.empty();
    }

    @Override
    public Mono<Void> disposeLater(Duration quietPeriod, Duration timeout) {
        return Mono.empty();
    }

    @Override
    public void disposeWhen(SocketAddress remoteAddress) {
        this.defaultProvider.disposeWhen(remoteAddress);
    }

    @Override
    public boolean isDisposed() {
        return this.defaultLoops.isDisposed() && this.defaultProvider.isDisposed();
    }

    @Override
    public int maxConnections() {
        return this.defaultProvider.maxConnections();
    }

    @Override
    public Map<SocketAddress, Integer> maxConnectionsPerHost() {
        return this.defaultProvider.maxConnectionsPerHost();
    }

    @Override
    public ConnectionProvider.Builder mutate() {
        return this.defaultProvider.mutate();
    }

    @Override
    public String name() {
        return this.defaultProvider.name();
    }

    @Override
    public <CHANNEL extends Channel> CHANNEL onChannel(Class<CHANNEL> channelType, EventLoopGroup group) {
        Objects.requireNonNull(channelType, "channelType");
        Objects.requireNonNull(group, "group");
        return this.defaultLoops.onChannel(channelType, group);
    }

    @Override
    public <CHANNEL extends Channel> Class<? extends CHANNEL> onChannelClass(Class<CHANNEL> channelType, EventLoopGroup group) {
        Objects.requireNonNull(channelType, "channelType");
        Objects.requireNonNull(group, "group");
        return this.defaultLoops.onChannelClass(channelType, group);
    }

    @Override
    public EventLoopGroup onClient(boolean useNative) {
        return this.defaultLoops.onClient(useNative);
    }

    @Override
    public EventLoopGroup onServer(boolean useNative) {
        return this.defaultLoops.onServer(useNative);
    }

    @Override
    public EventLoopGroup onServerSelect(boolean useNative) {
        return this.defaultLoops.onServerSelect(useNative);
    }

    protected void _dispose() {
        this.defaultProvider.dispose();
        this._disposeResolver();
        this.defaultLoops.dispose();
    }

    protected Mono<Void> _disposeLater(Duration quietPeriod, Duration timeout) {
        return Mono.when(this._disposeResolverLater(), this.defaultLoops.disposeLater(quietPeriod, timeout), this.defaultProvider.disposeLater());
    }

    protected AddressResolverGroup<?> getOrCreateDefaultResolver() {
        AddressResolverGroup<?> resolverGroup = this.defaultResolver.get();
        if (resolverGroup == null) {
            DnsAddressResolverGroup newResolverGroup = DEFAULT_NAME_RESOLVER_PROVIDER.newNameResolverGroup(this.defaultLoops, LoopResources.DEFAULT_NATIVE);
            if (!this.defaultResolver.compareAndSet(null, newResolverGroup)) {
                newResolverGroup.close();
            }
            resolverGroup = this.getOrCreateDefaultResolver();
        }
        return resolverGroup;
    }

    void _disposeResolver() {
        AddressResolverGroup<?> addressResolverGroup = this.defaultResolver.get();
        if (addressResolverGroup != null) {
            addressResolverGroup.close();
        }
    }

    Mono<Void> _disposeResolverLater() {
        Mono<Void> disposeResolver = Mono.empty();
        AddressResolverGroup<?> addressResolverGroup = this.defaultResolver.get();
        if (addressResolverGroup != null) {
            disposeResolver = Mono.fromRunnable(addressResolverGroup::close);
        }
        return disposeResolver;
    }

    protected static <T extends TcpResources> T getOrCreate(AtomicReference<T> ref, @Nullable LoopResources loops, @Nullable ConnectionProvider provider, BiFunction<LoopResources, ConnectionProvider, T> onNew, String name) {
        TcpResources resources2;
        while ((resources2 = (TcpResources)ref.get()) == null || loops != null || provider != null) {
            TcpResources update = TcpResources.create(resources2, loops, provider, name, onNew);
            if (ref.compareAndSet(resources2, update)) {
                if (resources2 != null) {
                    if (loops != null) {
                        if (log.isWarnEnabled()) {
                            log.warn("[{}] resources will use a new LoopResources: {}, the previous LoopResources will be disposed", name, loops);
                        }
                        resources2._disposeResolver();
                        resources2.defaultLoops.dispose();
                    }
                    if (provider != null) {
                        if (log.isWarnEnabled()) {
                            log.warn("[{}] resources will use a new ConnectionProvider: {}, the previous ConnectionProvider will be disposed", name, provider);
                        }
                        resources2.defaultProvider.dispose();
                    }
                } else {
                    String poolType;
                    String loopType;
                    String string = loopType = loops == null ? "default" : "provided";
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] resources will use the {} LoopResources: {}", name, loopType, update.defaultLoops);
                    }
                    String string2 = poolType = provider == null ? "default" : "provided";
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] resources will use the {} ConnectionProvider: {}", name, poolType, update.defaultProvider);
                    }
                }
                return (T)update;
            }
            update._dispose();
        }
        return (T)resources2;
    }

    static <T extends TcpResources> T create(@Nullable T previous, @Nullable LoopResources loops, @Nullable ConnectionProvider provider, String name, BiFunction<LoopResources, ConnectionProvider, T> onNew) {
        if (previous == null) {
            loops = loops == null ? LoopResources.create("reactor-" + name) : loops;
            provider = provider == null ? ConnectionProvider.create(name, 500) : provider;
        } else {
            loops = loops == null ? previous.defaultLoops : loops;
            provider = provider == null ? previous.defaultProvider : provider;
        }
        return (T)((TcpResources)onNew.apply(loops, provider));
    }

    static {
        log = Loggers.getLogger(TcpResources.class);
        DEFAULT_NAME_RESOLVER_PROVIDER = NameResolverProvider.builder().build();
        ON_TCP_NEW = TcpResources::new;
        tcpResources = new AtomicReference();
    }
}

