/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.time.Duration;
import reactor.netty.Metrics;
import reactor.netty.channel.MeterKey;
import reactor.netty.http.MicrometerHttpMetricsRecorder;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.netty.internal.util.MapUtils;

final class MicrometerHttpClientMetricsRecorder
extends MicrometerHttpMetricsRecorder
implements HttpClientMetricsRecorder {
    static final MicrometerHttpClientMetricsRecorder INSTANCE = new MicrometerHttpClientMetricsRecorder();

    private MicrometerHttpClientMetricsRecorder() {
        super("reactor.netty.http.client", "http");
    }

    @Override
    public void recordDataReceivedTime(SocketAddress remoteAddress, String uri, String method2, String status, Duration time) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, method2, status);
        Timer dataReceivedTime = MapUtils.computeIfAbsent(this.dataReceivedTimeCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(Timer.builder((String)(this.name() + ".data.received.time")).description("Time spent in consuming incoming data").tags(new String[]{"remote.address", address, "uri", uri, "method", method2, "status", status}).register(Metrics.REGISTRY)));
        if (dataReceivedTime != null) {
            dataReceivedTime.record(time);
        }
    }

    @Override
    public void recordDataSentTime(SocketAddress remoteAddress, String uri, String method2, Duration time) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, method2, null);
        Timer dataSentTime = MapUtils.computeIfAbsent(this.dataSentTimeCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(Timer.builder((String)(this.name() + ".data.sent.time")).description("Time spent in sending outgoing data").tags(new String[]{"remote.address", address, "uri", uri, "method", method2}).register(Metrics.REGISTRY)));
        if (dataSentTime != null) {
            dataSentTime.record(time);
        }
    }

    @Override
    public void recordResponseTime(SocketAddress remoteAddress, String uri, String method2, String status, Duration time) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, method2, status);
        Timer responseTime = MapUtils.computeIfAbsent(this.responseTimeCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(Timer.builder((String)(this.name() + ".response.time")).description("Total time for the request/response").tags(new String[]{"remote.address", address, "uri", uri, "method", method2, "status", status}).register(Metrics.REGISTRY)));
        if (responseTime != null) {
            responseTime.record(time);
        }
    }
}

