/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.MatrixVariable;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueSyncArgumentResolver;
import org.springframework.web.server.ServerErrorException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;

public class MatrixVariableMethodArgumentResolver
extends AbstractNamedValueSyncArgumentResolver {
    public MatrixVariableMethodArgumentResolver(@Nullable ConfigurableBeanFactory factory, ReactiveAdapterRegistry registry) {
        super(factory, registry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.checkAnnotatedParamNoReactiveWrapper(parameter, MatrixVariable.class, (ann, type) -> !Map.class.isAssignableFrom((Class<?>)type) || StringUtils.hasText(ann.name()));
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        MatrixVariable ann = parameter.getParameterAnnotation(MatrixVariable.class);
        Assert.state(ann != null, "No MatrixVariable annotation");
        return new MatrixVariableNamedValueInfo(ann);
    }

    @Override
    @Nullable
    protected Object resolveNamedValue(String name, MethodParameter param, ServerWebExchange exchange2) {
        Map pathParameters = (Map)exchange2.getAttribute(HandlerMapping.MATRIX_VARIABLES_ATTRIBUTE);
        if (CollectionUtils.isEmpty(pathParameters)) {
            return null;
        }
        MatrixVariable ann = param.getParameterAnnotation(MatrixVariable.class);
        Assert.state(ann != null, "No MatrixVariable annotation");
        String pathVar = ann.pathVar();
        List paramValues = null;
        if (!pathVar.equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
            if (pathParameters.containsKey(pathVar)) {
                paramValues = (List)((MultiValueMap)pathParameters.get(pathVar)).get(name);
            }
        } else {
            boolean found = false;
            paramValues = new ArrayList();
            for (MultiValueMap params : pathParameters.values()) {
                if (!params.containsKey(name)) continue;
                if (found) {
                    String paramType = param.getNestedParameterType().getName();
                    throw new ServerErrorException("Found more than one match for URI path parameter '" + name + "' for parameter type [" + paramType + "]. Use 'pathVar' attribute to disambiguate.", param, null);
                }
                paramValues.addAll((Collection)params.get(name));
                found = true;
            }
        }
        if (CollectionUtils.isEmpty(paramValues)) {
            return null;
        }
        if (paramValues.size() == 1) {
            return paramValues.get(0);
        }
        return paramValues;
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) throws ServerWebInputException {
        String paramInfo = parameter.getNestedParameterType().getSimpleName();
        throw new ServerWebInputException("Missing matrix variable '" + name + "' for method parameter of type " + paramInfo, parameter);
    }

    private static final class MatrixVariableNamedValueInfo
    extends AbstractNamedValueArgumentResolver.NamedValueInfo {
        private MatrixVariableNamedValueInfo(MatrixVariable annotation) {
            super(annotation.name(), annotation.required(), annotation.defaultValue());
        }
    }
}

