/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.reactive.resource.ResourceTransformer;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CachingResourceTransformer
implements ResourceTransformer {
    private static final Log logger = LogFactory.getLog(CachingResourceTransformer.class);
    private final Cache cache;

    public CachingResourceTransformer(Cache cache) {
        Assert.notNull((Object)cache, "Cache is required");
        this.cache = cache;
    }

    public CachingResourceTransformer(CacheManager cacheManager, String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("Cache '" + cacheName + "' not found");
        }
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    @Override
    public Mono<Resource> transform(ServerWebExchange exchange2, Resource resource, ResourceTransformerChain transformerChain) {
        Resource cachedResource = this.cache.get((Object)resource, Resource.class);
        if (cachedResource != null) {
            if (logger.isTraceEnabled()) {
                logger.trace(exchange2.getLogPrefix() + "Resource resolved from cache");
            }
            return Mono.just(cachedResource);
        }
        return transformerChain.transform(exchange2, resource).doOnNext(transformed -> this.cache.put(resource, transformed));
    }
}

