/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Scanner;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.reactive.resource.ResourceTransformerSupport;
import org.springframework.web.reactive.resource.TransformedResource;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

@Deprecated
public class AppCacheManifestTransformer
extends ResourceTransformerSupport {
    private static final String MANIFEST_HEADER = "CACHE MANIFEST";
    private static final String CACHE_HEADER = "CACHE:";
    private static final Collection<String> MANIFEST_SECTION_HEADERS = Arrays.asList("CACHE MANIFEST", "NETWORK:", "FALLBACK:", "CACHE:");
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Log logger = LogFactory.getLog(AppCacheManifestTransformer.class);
    private final String fileExtension;

    public AppCacheManifestTransformer() {
        this("appcache");
    }

    public AppCacheManifestTransformer(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @Override
    public Mono<Resource> transform(ServerWebExchange exchange2, Resource inputResource, ResourceTransformerChain chain) {
        return chain.transform(exchange2, inputResource).flatMap(outputResource -> {
            String name = outputResource.getFilename();
            if (!this.fileExtension.equals(StringUtils.getFilenameExtension(name))) {
                return Mono.just(outputResource);
            }
            DataBufferFactory bufferFactory = exchange2.getResponse().bufferFactory();
            Flux<DataBuffer> flux = DataBufferUtils.read(outputResource, bufferFactory, 4096);
            return DataBufferUtils.join(flux).flatMap(dataBuffer -> {
                CharBuffer charBuffer = DEFAULT_CHARSET.decode(dataBuffer.asByteBuffer());
                DataBufferUtils.release(dataBuffer);
                String content = charBuffer.toString();
                return this.transform(content, (Resource)outputResource, chain, exchange2);
            });
        });
    }

    private Mono<? extends Resource> transform(String content, Resource resource, ResourceTransformerChain chain, ServerWebExchange exchange2) {
        if (!content.startsWith(MANIFEST_HEADER)) {
            if (logger.isTraceEnabled()) {
                logger.trace(exchange2.getLogPrefix() + "Skipping " + resource + ": Manifest does not start with 'CACHE MANIFEST'");
            }
            return Mono.just(resource);
        }
        return Flux.generate(new LineInfoGenerator(content)).concatMap(info -> this.processLine((LineInfo)info, exchange2, resource, chain)).reduce(new ByteArrayOutputStream(), (out, line) -> {
            AppCacheManifestTransformer.writeToByteArrayOutputStream(out, line + "\n");
            return out;
        }).map(out -> {
            String hash = DigestUtils.md5DigestAsHex(out.toByteArray());
            AppCacheManifestTransformer.writeToByteArrayOutputStream(out, "\n# Hash: " + hash);
            return new TransformedResource(resource, out.toByteArray());
        });
    }

    private static void writeToByteArrayOutputStream(ByteArrayOutputStream out, String toWrite) {
        try {
            byte[] bytes = toWrite.getBytes(DEFAULT_CHARSET);
            out.write(bytes);
        }
        catch (IOException ex) {
            throw Exceptions.propagate(ex);
        }
    }

    private Mono<String> processLine(LineInfo info, ServerWebExchange exchange2, Resource resource, ResourceTransformerChain chain) {
        if (!info.isLink()) {
            return Mono.just(info.getLine());
        }
        String link = this.toAbsolutePath(info.getLine(), exchange2);
        return this.resolveUrlPath(link, exchange2, resource, chain);
    }

    private static class LineInfo {
        private final String line;
        private final boolean cacheSection;
        private final boolean link;

        LineInfo(String line, @Nullable LineInfo previousLine) {
            this.line = line;
            this.cacheSection = LineInfo.initCacheSectionFlag(line, previousLine);
            this.link = LineInfo.iniLinkFlag(line, this.cacheSection);
        }

        private static boolean initCacheSectionFlag(String line, @Nullable LineInfo previousLine) {
            String trimmedLine = line.trim();
            if (MANIFEST_SECTION_HEADERS.contains(trimmedLine)) {
                return trimmedLine.equals(AppCacheManifestTransformer.CACHE_HEADER);
            }
            if (previousLine != null) {
                return previousLine.isCacheSection();
            }
            throw new IllegalStateException("Manifest does not start with CACHE MANIFEST: " + line);
        }

        private static boolean iniLinkFlag(String line, boolean isCacheSection) {
            return isCacheSection && StringUtils.hasText(line) && !line.startsWith("#") && !line.startsWith("//") && !LineInfo.hasScheme(line);
        }

        private static boolean hasScheme(String line) {
            int index = line.indexOf(58);
            return line.startsWith("//") || index > 0 && !line.substring(0, index).contains("/");
        }

        public String getLine() {
            return this.line;
        }

        public boolean isCacheSection() {
            return this.cacheSection;
        }

        public boolean isLink() {
            return this.link;
        }
    }

    private static class LineInfoGenerator
    implements Consumer<SynchronousSink<LineInfo>> {
        private final Scanner scanner;
        @Nullable
        private LineInfo previous;

        LineInfoGenerator(String content) {
            this.scanner = new Scanner(content);
        }

        @Override
        public void accept(SynchronousSink<LineInfo> sink) {
            if (this.scanner.hasNext()) {
                String line = this.scanner.nextLine();
                LineInfo current = new LineInfo(line, this.previous);
                sink.next(current);
                this.previous = current;
            } else {
                sink.complete();
            }
        }
    }
}

