/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.multipart;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Callable;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.MultipartUtils;
import org.springframework.http.codec.multipart.Part;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

abstract class DefaultParts {
    DefaultParts() {
    }

    public static FormFieldPart formFieldPart(HttpHeaders headers2, String value) {
        Assert.notNull((Object)headers2, "Headers must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return new DefaultFormFieldPart(headers2, value);
    }

    public static Part part(HttpHeaders headers2, Flux<DataBuffer> dataBuffers) {
        Assert.notNull((Object)headers2, "Headers must not be null");
        Assert.notNull(dataBuffers, "DataBuffers must not be null");
        return DefaultParts.partInternal(headers2, new FluxContent(dataBuffers));
    }

    public static Part part(HttpHeaders headers2, Path file, Scheduler scheduler) {
        Assert.notNull((Object)headers2, "Headers must not be null");
        Assert.notNull((Object)file, "File must not be null");
        Assert.notNull((Object)scheduler, "Scheduler must not be null");
        return DefaultParts.partInternal(headers2, new FileContent(file, scheduler));
    }

    private static Part partInternal(HttpHeaders headers2, Content content) {
        String filename = headers2.getContentDisposition().getFilename();
        if (filename != null) {
            return new DefaultFilePart(headers2, content);
        }
        return new DefaultPart(headers2, content);
    }

    private static final class FileContent
    implements Content {
        private final Path file;
        private final Scheduler scheduler;

        public FileContent(Path file, Scheduler scheduler) {
            this.file = file;
            this.scheduler = scheduler;
        }

        @Override
        public Flux<DataBuffer> content() {
            return DataBufferUtils.readByteChannel(() -> Files.newByteChannel(this.file, StandardOpenOption.READ), DefaultDataBufferFactory.sharedInstance, 1024).subscribeOn(this.scheduler);
        }

        @Override
        public Mono<Void> transferTo(Path dest) {
            return this.blockingOperation(() -> Files.copy(this.file, dest, StandardCopyOption.REPLACE_EXISTING));
        }

        @Override
        public Mono<Void> delete() {
            return this.blockingOperation(() -> {
                Files.delete(this.file);
                return null;
            });
        }

        private Mono<Void> blockingOperation(Callable<?> callable) {
            return Mono.create(sink -> {
                try {
                    callable.call();
                    sink.success();
                }
                catch (Exception ex) {
                    sink.error(ex);
                }
            }).subscribeOn(this.scheduler);
        }
    }

    private static final class FluxContent
    implements Content {
        private final Flux<DataBuffer> content;

        public FluxContent(Flux<DataBuffer> content) {
            this.content = content;
        }

        @Override
        public Flux<DataBuffer> content() {
            return this.content;
        }

        @Override
        public Mono<Void> transferTo(Path dest) {
            return DataBufferUtils.write(this.content, dest, new OpenOption[0]);
        }

        @Override
        public Mono<Void> delete() {
            return Mono.empty();
        }
    }

    private static interface Content {
        public Flux<DataBuffer> content();

        public Mono<Void> transferTo(Path var1);

        public Mono<Void> delete();
    }

    private static final class DefaultFilePart
    extends DefaultPart
    implements FilePart {
        public DefaultFilePart(HttpHeaders headers2, Content content) {
            super(headers2, content);
        }

        @Override
        public String filename() {
            String filename = this.headers().getContentDisposition().getFilename();
            Assert.state(filename != null, "No filename found");
            return filename;
        }

        @Override
        public Mono<Void> transferTo(Path dest) {
            return this.content.transferTo(dest);
        }

        @Override
        public String toString() {
            ContentDisposition contentDisposition = this.headers().getContentDisposition();
            String name = contentDisposition.getName();
            String filename = contentDisposition.getFilename();
            if (name != null) {
                return "DefaultFilePart{" + name + " (" + filename + ")}";
            }
            return "DefaultFilePart{(" + filename + ")}";
        }
    }

    private static class DefaultPart
    extends AbstractPart {
        protected final Content content;

        public DefaultPart(HttpHeaders headers2, Content content) {
            super(headers2);
            this.content = content;
        }

        @Override
        public Flux<DataBuffer> content() {
            return this.content.content();
        }

        @Override
        public Mono<Void> delete() {
            return this.content.delete();
        }

        public String toString() {
            String name = this.headers().getContentDisposition().getName();
            if (name != null) {
                return "DefaultPart{" + name + "}";
            }
            return "DefaultPart";
        }
    }

    private static class DefaultFormFieldPart
    extends AbstractPart
    implements FormFieldPart {
        private final String value;

        public DefaultFormFieldPart(HttpHeaders headers2, String value) {
            super(headers2);
            this.value = value;
        }

        @Override
        public Flux<DataBuffer> content() {
            return Flux.defer(() -> {
                byte[] bytes = this.value.getBytes(MultipartUtils.charset(this.headers()));
                return Flux.just(DefaultDataBufferFactory.sharedInstance.wrap(bytes));
            });
        }

        @Override
        public String value() {
            return this.value;
        }

        public String toString() {
            String name = this.headers().getContentDisposition().getName();
            if (name != null) {
                return "DefaultFormFieldPart{" + this.name() + "}";
            }
            return "DefaultFormFieldPart";
        }
    }

    private static abstract class AbstractPart
    implements Part {
        private final HttpHeaders headers;

        protected AbstractPart(HttpHeaders headers2) {
            Assert.notNull((Object)headers2, "HttpHeaders is required");
            this.headers = headers2;
        }

        @Override
        public String name() {
            String name = this.headers().getContentDisposition().getName();
            Assert.state(name != null, "No name available");
            return name;
        }

        @Override
        public HttpHeaders headers() {
            return this.headers;
        }
    }
}

