/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.core.script.jsr223;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetlinks.simulator.core.script.CompiledScript;
import org.jetlinks.simulator.core.script.ExposedScript;
import org.jetlinks.simulator.core.script.Script;
import org.jetlinks.simulator.core.script.jsr223.Jsr223ScriptFactory;

public abstract class JavaScriptFactory
extends Jsr223ScriptFactory {
    private final Set<Method> ignoreMethod = new HashSet<Method>(Stream.concat(Arrays.stream(Object.class.getMethods()), Arrays.stream(Callable.class.getMethods())).collect(Collectors.toList()));

    @Override
    protected final String prepare(Script script) {
        StringJoiner wrap = new StringJoiner("\n");
        wrap.add("(function(){");
        wrap.add("function exit(){};function Function(e){return function(){}};function quit(){};function eval(s){};this.eval = function(e){};function readFully(){};function readLine(){};var console = _$console;var utils = _$utils;const print = function(e){console.log(e)};const echo = print;");
        wrap.add("/*  script start */");
        wrap.add(script.getContent());
        wrap.add("/*  script end */");
        wrap.add("})()");
        return wrap.toString();
    }

    @Override
    public <T> ExposedScript<T> compileExpose(Script script, Class<? super T> expose) {
        StringJoiner joiner = new StringJoiner("\n");
        HashSet distinct = new HashSet();
        joiner.add("let _$this = $this;");
        joiner.add(Arrays.stream(expose.getMethods()).filter(method2 -> !this.ignoreMethod.contains(method2)).sorted(Comparator.comparingInt(Method::getParameterCount).reversed()).map(method2 -> {
            if (!distinct.add(method2.getName())) {
                return null;
            }
            StringBuilder call = new StringBuilder("function ").append(method2.getName()).append("(){");
            if (method2.getParameterCount() == 0) {
                call.append("return _$this.").append(method2.getName()).append("();");
            } else if (method2.getParameterCount() == 1 && method2.getParameterTypes()[0].isArray()) {
                call.append("return _$this.").append(method2.getName()).append("(utils.toJavaType(arguments));");
            } else {
                for (int i2 = 0; i2 <= method2.getParameterCount(); ++i2) {
                    CharSequence[] args = new String[i2];
                    for (int j = 0; j < i2; ++j) {
                        args[j] = "arguments[" + j + "]";
                    }
                    String arg = String.join((CharSequence)",", args);
                    call.append("if(arguments.length==").append(i2).append("){").append("return _$this.").append(method2.getName()).append("(").append(arg).append(");").append("}");
                }
            }
            call.append("}");
            return call.toString();
        }).filter(Objects::nonNull).collect(Collectors.joining("\n")));
        joiner.add(script.getContent());
        CompiledScript compiledScript = this.compile(script.content(joiner.toString()));
        return (instance, ctx) -> {
            ctx.setAttribute("$this", instance, 100);
            return compiledScript.call(ctx);
        };
    }

    @Override
    protected String createFunctionMapping(Method[] methods) {
        return Arrays.stream(methods).map(Method::getName).map(m3 -> m3 + ":typeof(" + m3 + ")==='undefined'?null:" + m3).collect(Collectors.joining(",", "{", "}"));
    }
}

