/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.core.network.mqtt;

import io.vertx.mqtt.MqttClientOptions;
import java.util.Map;

public class MqttOptions
extends MqttClientOptions {
    String host = "127.0.0.1";
    int port = 1883;

    public MqttOptions() {
    }

    private MqttOptions(MqttOptions options) {
        super(options);
        this.setHost(options.getHost());
        this.setPort(options.getPort());
    }

    @Override
    public String toString() {
        return String.format("mqtt://%s@%s:%d", this.getClientId(), this.host, this.port);
    }

    public MqttOptions copy() {
        return new MqttOptions(this);
    }

    private MqttOptions apply(Map<String, Object> args) {
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            String key = "{" + entry.getKey() + "}";
            String value = String.valueOf(entry.getValue());
            this.setClientId(this.getClientId().replace(key, value));
            if (this.getUsername() != null) {
                this.setUsername(this.getUsername().replace(key, value));
            }
            if (this.getPassword() == null) continue;
            this.setPassword(this.getPassword().replace(key, value));
        }
        return this;
    }

    public MqttOptions refactor(Map<String, Object> args) {
        return this.copy().apply(args);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

