/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd.http;

import io.netty.buffer.ByteBufUtil;
import io.vertx.core.buffer.Buffer;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetlinks.simulator.cmd.AbstractCommand;
import org.jetlinks.simulator.cmd.CommonCommand;
import org.jetlinks.simulator.cmd.ConnectionAttachCommand;
import org.jetlinks.simulator.cmd.FullScreenCommand;
import org.jetlinks.simulator.cmd.http.CreateHttpCommand;
import org.jetlinks.simulator.core.Connection;
import org.jetlinks.simulator.core.ConnectionManager;
import org.jetlinks.simulator.core.ExceptionUtils;
import org.jetlinks.simulator.core.network.NetworkType;
import org.jetlinks.simulator.core.network.http.HTTPClient;
import org.jetlinks.simulator.core.network.http.HttpResponse;
import org.jline.utils.AttributedString;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(name="attach", description={"Attach HTTP Client"})
public class HTTPAttachCommand
extends ConnectionAttachCommand {
    @Override
    @CommandLine.Parameters(paramLabel="id", completionCandidates=IdComplete.class)
    public void setId(String id) {
        super.setId(id);
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doDestroy() {
        super.doDestroy();
    }

    @Override
    protected void createHeader(List<AttributedString> lines) {
        super.createHeader(lines);
        lines.add(HTTPAttachCommand.createLine(builder -> {
            HTTPClient client = this.connection.unwrap(HTTPClient.class);
            builder.append("          ");
            builder.append("BasePath: ");
            builder.append(client.getBasePath() == null ? "/" : client.getBasePath(), green);
        }));
    }

    @Override
    protected CommandLine commandLine() {
        CommandLine line = super.commandLine();
        line.registerConverter(HttpHeaders.class, new CreateHttpCommand.HttpHeaderConverter());
        return line;
    }

    private void createResponseLine(List<AttributedString> lines, HttpResponse response, long time) {
        lines.add(HTTPAttachCommand.createLine(builder -> builder.append(response.getVersion().alpnName().toUpperCase()).append(" ").append(String.valueOf(response.getStatus().value())).append(" ").append(response.getStatus().name(), response.getStatus().is2xxSuccessful() ? green : red).append(" take ").append(String.valueOf(time)).append("ms")));
        HTTPAttachCommand.createHeaderLine(lines, response.getHeaders());
        Buffer body2 = response.getBody();
        if (body2.length() > 0) {
            String[] str;
            lines.add(AttributedString.EMPTY);
            MediaType mediaType = response.getHeaders().getContentType();
            String bodyStr = mediaType != null && mediaType.includes(MediaType.APPLICATION_OCTET_STREAM) ? ByteBufUtil.hexDump(body2.getByteBuf()) : (mediaType != null && mediaType.getCharset() != null ? body2.toString(mediaType.getCharset()) : body2.toString());
            for (String s2 : str = bodyStr.split("\n")) {
                lines.add(HTTPAttachCommand.createLine(builder -> builder.append(s2)));
            }
        }
    }

    public static void createHeaderLine(List<AttributedString> lines, HttpHeaders headers2) {
        if (headers2 == null) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : headers2.entrySet()) {
            lines.add(HTTPAttachCommand.createLine(builder -> builder.append((CharSequence)entry.getKey(), blue).append(": ").append(String.join((CharSequence)",", (Iterable)entry.getValue()), blue)));
        }
    }

    @Override
    protected AbstractCommand createCommand() {
        return new AttachCommands();
    }

    @CommandLine.Command(name="close", description={"Close UDP Client"})
    static class Close
    extends CommonCommand {
        Close() {
        }

        @Override
        public void run() {
            ((AttachCommands)this.parent).disconnect();
        }
    }

    @CommandLine.Command(name="request", description={"Send HTTP request"})
    static class Request
    extends CommonCommand {
        @CommandLine.Option(names={"-X", "--method"}, description={"Request method"}, required=true, defaultValue="GET")
        HttpMethod method;
        String payload;
        @CommandLine.Option(names={"--mediaType"}, description={"Media Type"}, completionCandidates=MediaTypeCompletion.class)
        String mediaType;
        @CommandLine.Option(names={"--file"}, description={"Request File Data"})
        File file;
        HttpHeaders headers;
        @CommandLine.Parameters
        String path;

        Request() {
        }

        @CommandLine.Option(names={"-d", "--data"}, description={"Request Data"})
        public void setPayload(String payload) {
            this.payload = payload.replace("\\n", "\n");
        }

        @CommandLine.Option(names={"-h", "--header"}, description={"Default Headers"})
        public void setHeaders(Map<String, String> header) {
            this.headers = new HttpHeaders();
            header.forEach(this.headers::add);
        }

        public void createMessage(List<AttributedString> lines, HttpHeaders defaultHeaders) {
            lines.add(FullScreenCommand.createLine(builder -> builder.append(this.method.name()).append(" ").append(this.path == null ? "/" : this.path)));
            HTTPAttachCommand.createHeaderLine(lines, this.headers);
            HTTPAttachCommand.createHeaderLine(lines, defaultHeaders);
            if (StringUtils.hasText(this.payload)) {
                lines.add(AttributedString.EMPTY);
                for (String str : this.payload.split("\n")) {
                    lines.add(FullScreenCommand.createLine(builder -> builder.append(str)));
                }
            }
        }

        private Object createBody() {
            return this.path;
        }

        @Override
        public void run() {
            ((AttachCommands)this.getParent()).request(this);
        }

        public void setMethod(HttpMethod method2) {
            this.method = method2;
        }

        public void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public void setPath(String path2) {
            this.path = path2;
        }
    }

    public static class MediaTypeCompletion
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return Arrays.asList("application/json", "application/xml", "text/plain").iterator();
        }
    }

    @CommandLine.Command(name="", subcommands={Request.class, Close.class}, customSynopsis={""}, synopsisHeading="")
    class AttachCommands
    extends CommonCommand {
        AttachCommands() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void request(Request request) {
            HTTPClient client = HTTPAttachCommand.this.connection.unwrap(HTTPClient.class);
            ArrayList<AttributedString> lines = new ArrayList<AttributedString>();
            lines.add(AttributedString.EMPTY);
            request.createMessage(lines, client.getHeaders());
            HTTPAttachCommand.this.messages.add(lines);
            long time = System.currentTimeMillis();
            try {
                HttpResponse response = client.request(io.vertx.core.http.HttpMethod.valueOf(request.method.name()), request.path, request.createBody(), request.mediaType, request.headers).block(Duration.ofSeconds(30L));
                long t = System.currentTimeMillis() - time;
                lines.add(AttributedString.EMPTY);
                if (response != null) {
                    HTTPAttachCommand.this.createResponseLine(lines, response, t);
                } else {
                    lines.add(AttributedString.fromAnsi("No Response!"));
                }
            }
            catch (Throwable e) {
                lines.add(AttributedString.EMPTY);
                lines.add(FullScreenCommand.createLine(builder -> builder.append("Error: " + ExceptionUtils.getErrorMessage(e), red)));
            }
            finally {
                if (HTTPAttachCommand.this.messages.size() > 50) {
                    HTTPAttachCommand.this.messages.removeFirst();
                }
            }
        }

        void disconnect() {
            HTTPAttachCommand.this.connection.dispose();
        }
    }

    static class IdComplete
    implements Iterable<String> {
        IdComplete() {
        }

        @Override
        public Iterator<String> iterator() {
            return ConnectionManager.global().getConnections().filter(c -> c.getType() == NetworkType.http_client).map(Connection::getId).collectList().block().iterator();
        }
    }
}

