/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.ColumnData;
import com.github.freva.asciitable.HorizontalAlign;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.jetlinks.reactor.ql.utils.SqlUtils;
import org.jetlinks.simulator.cmd.CommonCommand;
import org.jetlinks.simulator.core.Connection;
import org.jetlinks.simulator.core.ConnectionManager;
import org.jetlinks.simulator.core.ExceptionUtils;
import org.joda.time.DateTime;
import org.springframework.util.StringUtils;
import picocli.CommandLine;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@CommandLine.Command(name="list", description={"Search connections"}, headerHeading="%n")
public class ListConnection
extends CommonCommand
implements Runnable {
    @CommandLine.Option(names={"-e", "--expression"}, description={"query expression,e.g. \"type='mqtt'\" and clientId like 'test-%'"})
    private String expression;
    @CommandLine.Option(names={"-l", "--limit"}, description={"limit ,e.g. 20"})
    private int limit = 20;
    @CommandLine.Option(names={"-o", "--offset"}, description={"offset ,e.g. 0"})
    private int offset = 0;
    static List<ColumnData<Connection>> columns = Arrays.asList(ListConnection.createColumn("id", Connection::getId), ListConnection.createColumn("type", Connection::getType), ListConnection.createColumn("connectTime", d -> new DateTime(d.getConnectTime()).toString("HH:mm:ss")), ListConnection.createColumn("state", d -> d.state().name()), ListConnection.createAttrColumn("sent", "0"), ListConnection.createAttrColumn("sent_bytes", "0"), ListConnection.createAttrColumn("received", "0"), ListConnection.createAttrColumn("received_bytes", "0"));

    static ColumnData<Connection> createAttrColumn(String header, String defaultValue) {
        return ListConnection.createColumn(header, c -> c.attribute(header).orElse(defaultValue));
    }

    static ColumnData<Connection> createColumn(String header, Function<Connection, Object> converter) {
        return new Column().header(header).headerAlign(HorizontalAlign.CENTER).dataAlign(HorizontalAlign.LEFT).with(c -> {
            Object val = converter.apply((Connection)c);
            return val == null ? "" : String.valueOf(val);
        });
    }

    protected ConnectionManager connectionManager() {
        return this.main().connectionManager;
    }

    @Override
    public void run() {
        Flux<Connection> flux;
        long total = this.connectionManager().getConnectionSize();
        if (StringUtils.hasText(this.expression)) {
            this.printf("find connection, total:%d, expr %s limit %d,offset %d.%n", total, this.expression, this.limit, this.offset);
            flux = this.connectionManager().findConnection(SqlUtils.getCleanStr(this.expression));
        } else {
            this.printf("find connection, total:%d ,limit %d,offset %d.%n", total, this.limit, this.offset);
            flux = this.connectionManager().getConnections();
        }
        if (total == 0L) {
            return;
        }
        flux.skip(this.offset).take(this.limit).collectList().onErrorResume(err -> {
            this.printfError("%s%n", ExceptionUtils.getErrorMessage(err));
            return Mono.empty();
        }).subscribe(connection -> this.printf("%s%n", AsciiTable.builder().data(connection, columns).toString()));
    }
}

