/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd;

import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.jetlinks.simulator.cmd.AttachCommand;
import org.jetlinks.simulator.core.Connection;
import org.jline.utils.AttributedString;
import org.joda.time.DateTime;
import reactor.core.Disposable;
import reactor.core.Disposables;

public class ConnectionAttachCommand
extends AttachCommand {
    private String id;
    protected Connection connection;
    protected Deque<List<AttributedString>> messages;
    protected Disposable.Composite disposable;

    protected Connection getConnection() {
        return this.main().connectionManager().getConnectionNow(this.getId()).orElse(null);
    }

    @Override
    protected final void destroy() {
        this.disposable.dispose();
        this.doDestroy();
    }

    @Override
    protected void doClear() {
        super.doClear();
        this.messages.clear();
    }

    @Override
    protected final void init() {
        super.init();
        this.disposable = Disposables.composite();
        this.connection = this.getConnection();
        if (this.connection == null) {
            throw new IllegalArgumentException(String.format("connection [%s] not found", this.getId()));
        }
        this.messages = (Deque)this.connection.attribute("__msgCache").orElseGet(ConcurrentLinkedDeque::new);
        this.connection.attribute("__msgCache", this.messages);
        this.doInit();
    }

    protected void doDestroy() {
    }

    protected void doInit() {
    }

    @Override
    protected void createHeader(List<AttributedString> lines) {
        lines.add(ConnectionAttachCommand.createLine(builder -> builder.append(this.connection.getId(), blue).append("(").append(this.connection.state().name(), this.connection.state() == Connection.State.connected ? green : red).append(")").append(" ").append(new DateTime(this.connection.getConnectTime()).toString("yyyy-MM-dd HH:mm:ss")).append(" sent: ").append(String.valueOf(this.connection.attribute("sent").orElse(0)), green).append("(").append(ConnectionAttachCommand.formatBytes(this.connection.attribute("sent_bytes").map(CastUtils::castNumber).orElse(0).longValue()), green).append(")").append(" received: ").append(String.valueOf(this.connection.attribute("received").orElse(0)), green).append("(").append(ConnectionAttachCommand.formatBytes(this.connection.attribute("received_bytes").map(CastUtils::castNumber).orElse(0).longValue()), green).append(")")));
    }

    @Override
    protected void createBody(List<AttributedString> lines) {
        for (List<AttributedString> message : this.messages) {
            lines.addAll(message);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

