/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cli;

import ch.qos.logback.core.ConsoleAppender;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.jline.reader.LineReader;
import reactor.core.Disposable;

public class TerminalAppender<E>
extends ConsoleAppender<E> {
    private LineReader console;
    private static final List<Consumer<String>> logConsumer = new CopyOnWriteArrayList<Consumer<String>>();

    public static Disposable listenLog(Consumer<String> consumer) {
        logConsumer.add(consumer);
        return () -> logConsumer.remove(consumer);
    }

    @Override
    protected void subAppend(E event) {
        if (this.console == null) {
            super.subAppend(event);
        } else if (logConsumer.isEmpty()) {
            this.console.printAbove(new String(this.getEncoder().encode(event)));
        } else {
            String log = new String(this.getEncoder().encode(event));
            for (Consumer<String> stringConsumer : logConsumer) {
                stringConsumer.accept(log);
            }
        }
    }

    public void setConsole(LineReader console) {
        this.console = console;
    }
}

