/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.group;

import java.util.HashMap;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Expression;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.GroupFeature;
import reactor.core.publisher.Flux;

public class TraceGroupRowFeature
implements GroupFeature {
    public static final String ID = FeatureId.GroupBy.of("trace").getId();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public Function<Flux<ReactorQLRecord>, Flux<Flux<ReactorQLRecord>>> createGroupMapper(Expression expression, ReactorQLMetadata metadata) {
        return flux -> flux.elapsed().index((index, row) -> {
            HashMap<String, Long> rowInfo = new HashMap<String, Long>();
            rowInfo.put("index", index + 1L);
            rowInfo.put("elapsed", (Long)row.getT1());
            ((ReactorQLRecord)row.getT2()).addRecord("row", rowInfo);
            return (ReactorQLRecord)row.getT2();
        }).as(Flux::just);
    }
}

