/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.feature;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.sf.jsqlparser.expression.ArrayExpression;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NumericBind;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.Feature;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.FilterFeature;
import org.jetlinks.reactor.ql.feature.PropertyFeature;
import org.jetlinks.reactor.ql.supports.ExpressionVisitorAdapter;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public interface ValueMapFeature
extends Feature {
    public Function<ReactorQLRecord, Publisher<?>> createMapper(Expression var1, ReactorQLMetadata var2);

    public static Function<ReactorQLRecord, Publisher<?>> createMapperNow(Expression expr, ReactorQLMetadata metadata) {
        return ValueMapFeature.createMapperByExpression(expr, metadata).orElseThrow(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c:" + expr));
    }

    public static Optional<Function<ReactorQLRecord, Publisher<?>>> createMapperByExpression(final Expression expr, final ReactorQLMetadata metadata) {
        final AtomicReference ref = new AtomicReference();
        expr.accept(new ExpressionVisitorAdapter(){

            @Override
            public void visit(net.sf.jsqlparser.expression.Function function) {
                metadata.getFeature(FeatureId.ValueMap.of(function.getName())).ifPresent(feature -> ref.set(feature.createMapper(function, metadata)));
            }

            @Override
            public void visit(SubSelect subSelect) {
                ref.set(metadata.getFeatureNow(FeatureId.ValueMap.select, expr::toString).createMapper(subSelect, metadata));
            }

            @Override
            public void visit(ExistsExpression exists) {
                Function<ReactorQLRecord, Publisher<?>> mapper = ValueMapFeature.createMapperNow(exists.getRightExpression(), metadata);
                boolean not = exists.isNot();
                ref.set(row -> Flux.from((Publisher)mapper.apply((ReactorQLRecord)row)).any(r -> true).map(r -> r != not));
            }

            @Override
            public void visit(ArrayExpression arrayExpression) {
                Expression indexExpr = arrayExpression.getIndexExpression();
                Expression objExpr = arrayExpression.getObjExpression();
                Function<ReactorQLRecord, Publisher<?>> objMapper = ValueMapFeature.createMapperNow(objExpr, metadata);
                Function<ReactorQLRecord, Publisher<?>> indexMapper = ValueMapFeature.createMapperNow(indexExpr, metadata);
                PropertyFeature propertyFeature = metadata.getFeatureNow(PropertyFeature.ID);
                ref.set(record -> Mono.zip(Mono.from((Publisher)indexMapper.apply((ReactorQLRecord)record)), Mono.from((Publisher)objMapper.apply((ReactorQLRecord)record)), propertyFeature::getProperty).handle((result, sink) -> result.ifPresent(sink::next)));
            }

            @Override
            public void visit(Parenthesis value) {
                ValueMapFeature.createMapperByExpression(value.getExpression(), metadata).ifPresent(ref::set);
            }

            @Override
            public void visit(CaseExpression expr2) {
                ref.set(metadata.getFeatureNow(FeatureId.ValueMap.caseWhen, expr2::toString).createMapper(expr2, metadata));
            }

            @Override
            public void visit(CastExpression expr2) {
                ref.set(metadata.getFeatureNow(FeatureId.ValueMap.cast, expr2::toString).createMapper(expr2, metadata));
            }

            @Override
            public void visit(Column column) {
                ref.set(metadata.getFeatureNow(FeatureId.ValueMap.property, column::toString).createMapper(column, metadata));
            }

            @Override
            public void visit(StringValue value) {
                Mono<String> val = Mono.just(value.getValue());
                ref.set(v -> val);
            }

            @Override
            public void visit(LongValue value) {
                Mono<Long> val = Mono.just(value.getValue());
                ref.set(v -> val);
            }

            @Override
            public void visit(JdbcParameter parameter) {
                int idx = parameter.isUseFixedIndex() ? parameter.getIndex() : parameter.getIndex() - 1;
                ref.set(record -> Mono.justOrEmpty(record.getContext().getParameter(idx)));
            }

            @Override
            public void visit(NumericBind nullValue) {
                int idx = nullValue.getBindId();
                ref.set(record -> Mono.justOrEmpty(record.getContext().getParameter(idx)));
            }

            @Override
            public void visit(JdbcNamedParameter parameter) {
                String name = parameter.getName();
                ref.set(record -> Mono.justOrEmpty(record.getContext().getParameter(name)));
            }

            @Override
            public void visit(DoubleValue value) {
                Mono<Double> val = Mono.just(value.getValue());
                ref.set(v -> val);
            }

            @Override
            public void visit(DateValue value) {
                Mono<Date> val = Mono.just(value.getValue());
                ref.set(v -> val);
            }

            @Override
            public void visit(HexValue value) {
                Mono<String> val = Mono.just(value.getValue());
                ref.set(v -> val);
            }

            @Override
            public void visit(SignedExpression expr2) {
                Function<Number, Number> doSign;
                char sign = expr2.getSign();
                Function<ReactorQLRecord, Publisher<?>> mapper = ValueMapFeature.createMapperNow(expr2.getExpression(), metadata);
                switch (sign) {
                    case '-': {
                        doSign = n -> CastUtils.castNumber(n, i2 -> -i2.intValue(), l -> -l.longValue(), d -> -d.doubleValue(), f -> Float.valueOf(-f.floatValue()), d -> -d.doubleValue());
                        break;
                    }
                    case '~': {
                        doSign = n -> n.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
                        break;
                    }
                    default: {
                        doSign = Function.identity();
                    }
                }
                ref.set(ctx -> Mono.from((Publisher)mapper.apply((ReactorQLRecord)ctx)).map(CastUtils::castNumber).map(doSign));
            }

            @Override
            public void visit(TimestampValue value) {
                Mono<Timestamp> val = Mono.just(value.getValue());
                ref.set(v -> val);
            }

            @Override
            public void visit(BinaryExpression jsonExpr) {
                metadata.getFeature(FeatureId.ValueMap.of(jsonExpr.getStringExpression())).map(feature -> feature.createMapper(expr, metadata)).ifPresent(ref::set);
                if (ref.get() == null) {
                    FilterFeature.createPredicateByExpression(expr, metadata).map(predicate -> ctx -> (Mono)predicate.apply(ctx, ctx.getRecord())).ifPresent(ref::set);
                }
            }
        });
        return Optional.ofNullable(ref.get());
    }

    public static Tuple2<Function<ReactorQLRecord, Publisher<?>>, Function<ReactorQLRecord, Publisher<?>>> createBinaryMapper(Expression expression, ReactorQLMetadata metadata) {
        Expression right;
        Expression left;
        if (expression instanceof net.sf.jsqlparser.expression.Function) {
            List<Expression> expressions;
            net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)expression;
            if (function.getParameters() == null || CollectionUtils.isEmpty(expressions = function.getParameters().getExpressions()) || expressions.size() != 2) {
                throw new IllegalArgumentException("The number of parameters must be 2 :" + expression);
            }
            left = expressions.get(0);
            right = expressions.get(1);
        } else if (expression instanceof BinaryExpression) {
            BinaryExpression bie = (BinaryExpression)expression;
            left = bie.getLeftExpression();
            right = bie.getRightExpression();
        } else {
            throw new UnsupportedOperationException("Unsupported expression:" + expression);
        }
        Function<ReactorQLRecord, Publisher<?>> leftMapper = ValueMapFeature.createMapperNow(left, metadata);
        Function<ReactorQLRecord, Publisher<?>> rightMapper = ValueMapFeature.createMapperNow(right, metadata);
        return Tuples.of(leftMapper, rightMapper);
    }
}

