/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.springframework.util.ConcurrentReferenceHashMap;

public class SerializeUtils {
    public static String readNullableUTF(ObjectInput in) {
        if (in.readBoolean()) {
            return null;
        }
        return in.readUTF();
    }

    public static void writeNullableUTF(String str, ObjectOutput out) {
        if (str == null) {
            out.writeBoolean(true);
            return;
        }
        out.writeBoolean(false);
        out.writeUTF(str);
    }

    public static void writeObject(Object obj, ObjectOutput out) {
        Type type = obj == null ? Type.NULL : Type.of(obj);
        out.writeByte(type.code);
        type.write(obj, out);
    }

    public static Object readObject(ObjectInput input) {
        Type type = Type.all[input.readByte()];
        return type.read(input);
    }

    public static <K, T> Map<K, T> readMap(ObjectInput in, Function<Integer, Map<K, T>> mapBuilder) {
        int headerSize = in.readInt();
        Map<Object, T> map = mapBuilder.apply(Math.max(8, headerSize));
        for (int i2 = 0; i2 < headerSize; ++i2) {
            Object key = SerializeUtils.readObject(in);
            Object value = SerializeUtils.readObject(in);
            map.put(key, value);
        }
        return map;
    }

    public static void readKeyValue(ObjectInput in, BiConsumer<String, Object> consumer) {
        int headerSize = in.readInt();
        for (int i2 = 0; i2 < headerSize; ++i2) {
            String key = String.valueOf(SerializeUtils.readObject(in));
            consumer.accept(key, SerializeUtils.readObject(in));
        }
    }

    public static void writeKeyValue(Map<?, ?> map, ObjectOutput out) {
        if (map == null) {
            out.writeInt(0);
        } else {
            out.writeInt(map.size());
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                SerializeUtils.writeObject(entry.getKey(), out);
                SerializeUtils.writeObject(entry.getValue(), out);
            }
        }
    }

    public static <T> void writeKeyValue(Collection<T> collection, Function<T, Object> keyMapper, Function<T, Object> valueMapper, ObjectOutput out) {
        if (collection == null) {
            out.writeInt(0);
        } else {
            out.writeInt(collection.size());
            for (T t : collection) {
                Object key = keyMapper.apply(t);
                Object value = valueMapper.apply(t);
                SerializeUtils.writeObject(key, out);
                SerializeUtils.writeObject(value, out);
            }
        }
    }

    private static enum Type {
        NULL(0, (Class)Void.class){

            @Override
            public Object read(ObjectInput in) {
                return null;
            }

            @Override
            void write(Object value, ObjectOutput input) {
            }
        }
        ,
        BOOLEAN(1, (Class)Boolean.class){

            @Override
            public Object read(ObjectInput in) {
                return in.readBoolean();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeBoolean((Boolean)value);
            }
        }
        ,
        BYTE(2, (Class)Byte.class){

            @Override
            Object read(ObjectInput input) {
                return input.readByte();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeByte(((Byte)value).byteValue());
            }
        }
        ,
        CHAR(3, (Class)Character.class){

            @Override
            Object read(ObjectInput input) {
                return Character.valueOf(input.readChar());
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeChar(((Character)value).charValue());
            }
        }
        ,
        SHORT(4, (Class)Short.class){

            @Override
            Object read(ObjectInput input) {
                return input.readShort();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeShort(((Short)value).shortValue());
            }
        }
        ,
        INT(5, (Class)Integer.class){

            @Override
            Object read(ObjectInput input) {
                return input.readInt();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeInt((Integer)value);
            }
        }
        ,
        LONG(6, (Class)Long.class){

            @Override
            Object read(ObjectInput input) {
                return input.readLong();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeLong((Long)value);
            }
        }
        ,
        FLOAT(7, (Class)Float.class){

            @Override
            Object read(ObjectInput input) {
                return Float.valueOf(input.readFloat());
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeFloat(((Float)value).floatValue());
            }
        }
        ,
        DOUBLE(8, (Class)Double.class){

            @Override
            Object read(ObjectInput input) {
                return input.readDouble();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeDouble((Double)value);
            }
        }
        ,
        BIG_DECIMAL(9, (Class)BigDecimal.class){
            private static final byte ZERO = 0;
            private static final byte ONE = 1;
            private static final byte SMALL_SCALE_0 = 16;
            private static final byte SMALL_SCALE_N = 17;
            private static final byte BIG_DECIMAL = 18;

            @Override
            Object read(ObjectInput input) {
                byte type = input.readByte();
                if (0 == type) {
                    return BigDecimal.ZERO;
                }
                if (1 == type) {
                    return BigDecimal.ONE;
                }
                if (16 == type) {
                    return BigDecimal.valueOf(input.readLong());
                }
                if (17 == type) {
                    int scale = input.readInt();
                    return BigDecimal.valueOf(input.readLong(), scale);
                }
                int scale = input.readInt();
                int len = input.readInt();
                byte[] bytes = new byte[len];
                input.read(bytes);
                BigInteger b = new BigInteger(bytes);
                return new BigDecimal(b, scale);
            }

            @Override
            void write(Object value, ObjectOutput input) {
                BigDecimal decimal = (BigDecimal)value;
                if (BigDecimal.ZERO.equals(decimal)) {
                    input.write(0);
                } else if (BigDecimal.ONE.equals(decimal)) {
                    input.write(1);
                } else {
                    int scale = decimal.scale();
                    BigInteger b = decimal.unscaledValue();
                    int bits = b.bitLength();
                    if (bits < 64) {
                        if (scale == 0) {
                            input.write(16);
                        } else {
                            input.write(17);
                            input.writeInt(scale);
                        }
                        input.writeLong(b.longValue());
                    } else {
                        byte[] bytes = b.toByteArray();
                        input.write(18);
                        input.writeInt(scale);
                        input.writeInt(bytes.length);
                        input.write(bytes);
                    }
                }
            }
        }
        ,
        BIG_INTEGER(10, (Class)BigInteger.class){
            private static final byte ZERO = 0;
            private static final byte ONE = 1;
            private static final byte SMALL = 16;
            private static final byte BIG_INTEGER = 18;

            @Override
            Object read(ObjectInput input) {
                byte type = input.readByte();
                if (0 == type) {
                    return BigInteger.ZERO;
                }
                if (1 == type) {
                    return BigInteger.ONE;
                }
                if (16 == type) {
                    return BigInteger.valueOf(input.readLong());
                }
                int len = input.readInt();
                byte[] bytes = new byte[len];
                input.read(bytes);
                return new BigInteger(bytes);
            }

            @Override
            void write(Object value, ObjectOutput input) {
                BigInteger b = (BigInteger)value;
                if (BigInteger.ZERO.equals(b)) {
                    input.write(0);
                } else if (BigInteger.ONE.equals(b)) {
                    input.write(1);
                } else {
                    int bits = b.bitLength();
                    if (bits < 64) {
                        input.write(16);
                        input.writeLong(b.longValue());
                    } else {
                        byte[] bytes = b.toByteArray();
                        input.write(18);
                        input.writeInt(bytes.length);
                        input.write(bytes);
                    }
                }
            }
        }
        ,
        STRING(11, (Class)String.class){

            @Override
            Object read(ObjectInput input) {
                return input.readUTF();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeUTF(String.valueOf(value));
            }
        }
        ,
        ARRAY(12, (Class)Object[].class){

            @Override
            Object read(ObjectInput input) {
                Type elementType = all[input.readByte()];
                int len = input.readInt();
                Object array = Array.newInstance(elementType.javaType, len);
                for (int i2 = 0; i2 < len; ++i2) {
                    Array.set(array, i2, SerializeUtils.readObject(input));
                }
                return array;
            }

            @Override
            void write(Object value, ObjectOutput input) {
                Class<?> type = value.getClass().getComponentType();
                Type elementType = Type.of(type);
                input.writeByte(elementType.ordinal());
                int len = Array.getLength(value);
                input.writeInt(len);
                for (int i2 = 0; i2 < len; ++i2) {
                    SerializeUtils.writeObject(Array.get(value, i2), input);
                }
            }
        }
        ,
        MAP(13, (Class)Map.class){

            @Override
            Object read(ObjectInput input) {
                return SerializeUtils.readMap(input, Maps::newLinkedHashMapWithExpectedSize);
            }

            @Override
            void write(Object value, ObjectOutput input) {
                SerializeUtils.writeKeyValue((Map)value, input);
            }
        }
        ,
        OBJECT(14, (Class)Serializable.class){

            @Override
            Object read(ObjectInput input) {
                return input.readObject();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeObject(value);
            }
        }
        ,
        LIST(15, (Class)List.class){

            @Override
            Object read(ObjectInput input) {
                int len = input.readInt();
                ArrayList<Object> list = new ArrayList<Object>(len);
                for (int i2 = 0; i2 < len; ++i2) {
                    list.add(SerializeUtils.readObject(input));
                }
                return list;
            }

            @Override
            void write(Object value, ObjectOutput input) {
                List list = (List)value;
                int len = list.size();
                input.writeInt(len);
                for (Object o : list) {
                    SerializeUtils.writeObject(o, input);
                }
            }
        }
        ,
        SET(19, (Class)Set.class){

            @Override
            Object read(ObjectInput input) {
                int len = input.readInt();
                LinkedHashSet<Object> list = Sets.newLinkedHashSetWithExpectedSize(len);
                for (int i2 = 0; i2 < len; ++i2) {
                    list.add(SerializeUtils.readObject(input));
                }
                return list;
            }

            @Override
            void write(Object value, ObjectOutput input) {
                Collection list = (Collection)value;
                int len = list.size();
                input.writeInt(len);
                for (Object o : list) {
                    SerializeUtils.writeObject(o, input);
                }
            }
        }
        ,
        C_SET(35, (Class)Set.class){

            @Override
            Object read(ObjectInput input) {
                int len = input.readInt();
                ConcurrentHashMap.KeySetView list = ConcurrentHashMap.newKeySet(len);
                for (int i2 = 0; i2 < len; ++i2) {
                    list.add(SerializeUtils.readObject(input));
                }
                return list;
            }

            @Override
            void write(Object value, ObjectOutput input) {
                Collection list = (Collection)value;
                int len = list.size();
                input.writeInt(len);
                for (Object o : list) {
                    SerializeUtils.writeObject(o, input);
                }
            }
        }
        ,
        C_MAP(32, (Class)ConcurrentMap.class){

            @Override
            Object read(ObjectInput input) {
                return SerializeUtils.readMap(input, ConcurrentHashMap::new);
            }

            @Override
            void write(Object value, ObjectOutput input) {
                SerializeUtils.writeKeyValue((Map)value, input);
            }
        }
        ,
        Netty(17, (Class)ByteBuf.class){

            @Override
            void write(Object value, ObjectOutput output) {
                ByteBuf buf = (ByteBuf)value;
                byte[] bytes = ByteBufUtil.getBytes(buf);
                ReferenceCountUtil.safeRelease(buf);
                output.writeInt(bytes.length);
                output.write(bytes);
            }

            @Override
            Object read(ObjectInput input) {
                int len = input.readInt();
                byte[] bytes = new byte[len];
                input.readFully(bytes);
                return Unpooled.wrappedBuffer(bytes);
            }
        }
        ,
        Nio(18, (Class)ByteBuffer.class){

            @Override
            void write(Object value, ObjectOutput output) {
                byte[] bytes;
                ByteBuffer buf = (ByteBuffer)value;
                if (buf.hasArray()) {
                    bytes = buf.array();
                } else {
                    bytes = new byte[buf.remaining()];
                    buf.get(bytes);
                }
                output.writeInt(bytes.length);
                output.write(bytes);
            }

            @Override
            Object read(ObjectInput input) {
                int len = input.readInt();
                byte[] bytes = new byte[len];
                input.readFully(bytes);
                return ByteBuffer.wrap(bytes);
            }
        }
        ,
        JSON(16, (Class)Object.class){
            private final Map<String, Class<?>> clazzCache = new ConcurrentReferenceHashMap();

            private Class<?> loadClass(String name) {
                return SerializeUtils.class.getClassLoader().loadClass(name);
            }

            @Override
            Object read(ObjectInput input) {
                String clazz = input.readUTF();
                Class tClass = this.clazzCache.computeIfAbsent(clazz, this::loadClass);
                int len = input.readInt();
                byte[] jsonByte = new byte[len];
                input.readFully(jsonByte);
                return com.alibaba.fastjson.JSON.parseObject(jsonByte, (java.lang.reflect.Type)tClass, new Feature[0]);
            }

            @Override
            void write(Object value, ObjectOutput output) {
                output.writeUTF(value.getClass().getName());
                byte[] jsonBytes = com.alibaba.fastjson.JSON.toJSONBytes(value, new SerializerFeature[0]);
                output.writeInt(jsonBytes.length);
                output.write(jsonBytes);
            }
        };

        private final int code;
        private final Class<?> javaType;
        static final Type[] all;
        private static final Map<Class<?>, Type> cache;

        abstract Object read(ObjectInput var1);

        abstract void write(Object var1, ObjectOutput var2);

        public static Type of(Object javaType) {
            if (javaType instanceof String) {
                return STRING;
            }
            if (javaType instanceof Boolean) {
                return BOOLEAN;
            }
            if (javaType instanceof Integer) {
                return INT;
            }
            if (javaType instanceof Long) {
                return LONG;
            }
            if (javaType instanceof Double) {
                return DOUBLE;
            }
            if (javaType instanceof Float) {
                return FLOAT;
            }
            if (javaType instanceof Byte) {
                return BYTE;
            }
            if (javaType instanceof Short) {
                return SHORT;
            }
            if (javaType instanceof Character) {
                return CHAR;
            }
            if (javaType instanceof BigDecimal) {
                return BIG_DECIMAL;
            }
            if (javaType instanceof BigInteger) {
                return BIG_INTEGER;
            }
            if (javaType instanceof ConcurrentMap) {
                return C_MAP;
            }
            if (javaType instanceof ConcurrentHashMap.KeySetView) {
                return C_SET;
            }
            if (javaType instanceof Map) {
                return MAP;
            }
            if (javaType instanceof List) {
                return LIST;
            }
            if (javaType instanceof Set) {
                return SET;
            }
            if (javaType instanceof ByteBuf) {
                return Netty;
            }
            if (javaType instanceof ByteBuffer) {
                return Nio;
            }
            return Type.of(javaType.getClass());
        }

        public static Type of(Class<?> javaType) {
            return cache.computeIfAbsent(javaType, t -> {
                if (t.isPrimitive()) {
                    t = Primitives.wrap(t);
                }
                for (Type type : all) {
                    if (type.javaType != t && !type.javaType.isAssignableFrom((Class<?>)t)) continue;
                    return type;
                }
                if (t.isArray() && !t.getComponentType().isPrimitive()) {
                    return ARRAY;
                }
                return JSON;
            });
        }

        private Type(int code, Class<?> javaType) {
            this.code = code;
            this.javaType = javaType;
        }

        static {
            all = new Type[255];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int j = 0; j < n; ++j) {
                Type value;
                Type.all[value.code] = value = typeArray[j];
            }
            cache = new ConcurrentReferenceHashMap();
        }
    }
}

