/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.api.common.AttributeKey;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.trace.MonoTracer;
import org.jetlinks.core.trace.TraceHolder;
import org.jetlinks.core.utils.StringBuilderUtils;
import reactor.core.publisher.Mono;

public interface DeviceTracer {
    public static <R> MonoTracer<R> fromMessage(Message message) {
        return MonoTracer.createWith(message.getHeaders());
    }

    public static <R extends Message> Mono<R> writeToMessage(R message) {
        return TraceHolder.writeContextTo(message, Message::addHeader);
    }

    public static interface SpanName {
        public static String operation(String deviceId, String operation) {
            return StringBuilderUtils.buildString(deviceId, operation, (str, opt, stringBuilder) -> stringBuilder.append("/device/").append((String)str).append("/").append((String)opt));
        }

        public static String connection(String deviceId) {
            return SpanName.operation(deviceId, "connection");
        }

        public static String auth(String deviceId) {
            return SpanName.operation(deviceId, "auth");
        }

        public static String decode(String deviceId) {
            return SpanName.operation(deviceId, "decode");
        }

        public static String encode(String deviceId) {
            return SpanName.operation(deviceId, "encode");
        }

        public static String request(String deviceId) {
            return SpanName.operation(deviceId, "request");
        }

        public static String response(String deviceId) {
            return SpanName.operation(deviceId, "response");
        }

        public static String downstream(String deviceId) {
            return SpanName.operation(deviceId, "downstream");
        }

        public static String upstream(String deviceId) {
            return SpanName.operation(deviceId, "upstream");
        }
    }

    public static interface SpanKey {
        public static final AttributeKey<String> deviceId = AttributeKey.stringKey("deviceId");
        public static final AttributeKey<String> message = AttributeKey.stringKey("message");
        public static final AttributeKey<String> response = AttributeKey.stringKey("response");
        public static final AttributeKey<String> address = AttributeKey.stringKey("address");
    }
}

