/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import org.springframework.lang.Nullable;

public class GeoPoint
implements Serializable {
    private static final long serialVersionUID = -6849794470754667710L;
    private double lon;
    private double lat;

    public static GeoPoint of(double lon, double lat) {
        return new GeoPoint(lon, lat);
    }

    public static GeoPoint of(Object val) {
        Object[] arr;
        if (val == null) {
            return null;
        }
        Object[] tmp = val;
        if (val instanceof GeoPoint) {
            return (GeoPoint)val;
        }
        if (val instanceof String) {
            String strVal = String.valueOf(val);
            val = strVal.startsWith("{") ? JSON.parseObject(strVal) : (strVal.startsWith("[") ? JSON.parseArray(strVal) : strVal.split("[,]"));
        }
        if (val instanceof Map) {
            Map mapVal = (Map)val;
            Object lon = mapVal.getOrDefault("lon", mapVal.get("y"));
            Object lat = mapVal.getOrDefault("lat", mapVal.get("x"));
            val = new Object[]{lon, lat};
        }
        if (val instanceof Collection) {
            val = ((Collection)val).toArray();
        }
        if (val instanceof Object[] && (arr = val).length >= 2) {
            return new GeoPoint(new BigDecimal(String.valueOf(arr[0])).doubleValue(), new BigDecimal(String.valueOf(arr[1])).doubleValue());
        }
        throw new IllegalArgumentException("unsupported geo format:" + tmp);
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.lat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeoPoint)) {
            return false;
        }
        GeoPoint other = (GeoPoint)obj;
        return Double.doubleToLongBits(this.lon) == Double.doubleToLongBits(other.lon) && Double.doubleToLongBits(this.lat) == Double.doubleToLongBits(other.lat);
    }

    public String toString() {
        return this.lon + "," + this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public GeoPoint(double lon, double lat) {
        this.lon = lon;
        this.lat = lat;
    }

    public GeoPoint() {
    }
}

