/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.property;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jetlinks.core.message.CommonThingMessage;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.property.ReadPropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessageReply;
import org.jetlinks.core.message.property.WriteThingPropertyMessage;
import org.jetlinks.core.things.ThingType;

public class DefaultWritePropertyMessage
extends CommonThingMessage<DefaultWritePropertyMessage>
implements WriteThingPropertyMessage<WritePropertyMessageReply> {
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();

    @Override
    public void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public WritePropertyMessageReply newReply() {
        return (WritePropertyMessageReply)new WritePropertyMessageReply().from(this);
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.WRITE_PROPERTY;
    }

    static ReadPropertyMessage forDevice(String deviceId) {
        ReadPropertyMessage message = new ReadPropertyMessage();
        message.setDeviceId(deviceId);
        return message;
    }

    static DefaultWritePropertyMessage forThing(ThingType thingType, String deviceId) {
        DefaultWritePropertyMessage message = new DefaultWritePropertyMessage();
        message.setThingId(deviceId);
        message.setThingType(thingType.getId());
        return message;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }
}

