/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec.http.websocket;

import io.netty.buffer.ByteBufUtil;
import java.nio.charset.StandardCharsets;
import org.jetlinks.core.message.codec.EncodedMessage;

public interface WebSocketMessage
extends EncodedMessage {
    public Type getType();

    default public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getType().name()).append("\n\n");
        if (ByteBufUtil.isText(this.getPayload(), StandardCharsets.UTF_8)) {
            builder.append(this.payloadAsString());
        } else {
            builder.append(ByteBufUtil.hexDump(this.getPayload()));
        }
        return builder.toString();
    }

    public static enum Type {
        TEXT,
        BINARY,
        PING,
        PONG;

    }
}

