/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jetlinks.core.message.codec.MessagePayloadType;
import org.jetlinks.core.message.codec.TextMessageParser;
import org.jetlinks.core.message.codec.http.Header;
import org.jetlinks.core.message.codec.http.HttpResponseMessage;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;

public class SimpleHttpResponseMessage
implements HttpResponseMessage {
    private int status;
    private MediaType contentType;
    private List<Header> headers = new ArrayList<Header>();
    private ByteBuf payload;

    public static SimpleHttpResponseMessageBuilder builder() {
        return new SimpleHttpResponseMessageBuilder();
    }

    @Override
    @Nonnull
    public List<Header> getHeaders() {
        return this.headers == null ? Collections.emptyList() : this.headers;
    }

    public static SimpleHttpResponseMessage of(String httpString) {
        SimpleHttpResponseMessage response = new SimpleHttpResponseMessage();
        HttpHeaders httpHeaders = new HttpHeaders();
        TextMessageParser.of(start -> {
            String[] firstLine = start.split("[ ]");
            response.setStatus(Integer.parseInt(firstLine[1].trim()));
        }, httpHeaders::add, body2 -> {
            response.setPayload(Unpooled.wrappedBuffer(body2.getBody()));
            if (httpHeaders.getContentType() == null) {
                if (body2.getType() == MessagePayloadType.JSON) {
                    response.setContentType(MediaType.APPLICATION_JSON);
                } else if (body2.getType() == MessagePayloadType.STRING) {
                    response.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                }
            }
            response.setContentType(httpHeaders.getContentType());
        }, () -> response.setPayload(Unpooled.EMPTY_BUFFER)).parse(httpString);
        response.setHeaders(httpHeaders.entrySet().stream().map(e -> new Header((String)e.getKey(), ((List)e.getValue()).toArray(new String[0]))).collect(Collectors.toList()));
        return response;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public MediaType getContentType() {
        return this.contentType;
    }

    @Override
    public ByteBuf getPayload() {
        return this.payload;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setContentType(MediaType contentType2) {
        this.contentType = contentType2;
    }

    public void setHeaders(List<Header> headers2) {
        this.headers = headers2;
    }

    public void setPayload(ByteBuf payload) {
        this.payload = payload;
    }

    public SimpleHttpResponseMessage(int status, MediaType contentType2, List<Header> headers2, ByteBuf payload) {
        this.status = status;
        this.contentType = contentType2;
        this.headers = headers2;
        this.payload = payload;
    }

    public SimpleHttpResponseMessage() {
    }

    public static class SimpleHttpResponseMessageBuilder {
        private int status;
        private MediaType contentType;
        private List<Header> headers;
        private ByteBuf payload;

        SimpleHttpResponseMessageBuilder() {
        }

        public SimpleHttpResponseMessageBuilder body(String payload) {
            return this.payload(payload.getBytes());
        }

        public SimpleHttpResponseMessageBuilder body(byte[] payload) {
            return this.payload(Unpooled.wrappedBuffer(payload));
        }

        public SimpleHttpResponseMessageBuilder payload(String payload) {
            return this.payload(payload.getBytes());
        }

        public SimpleHttpResponseMessageBuilder payload(byte[] payload) {
            return this.payload(Unpooled.wrappedBuffer(payload));
        }

        public SimpleHttpResponseMessageBuilder contentType(String mediaType) {
            return this.contentType(MediaType.valueOf(mediaType));
        }

        public SimpleHttpResponseMessageBuilder header(String key, String ... values) {
            if (this.headers == null) {
                this.headers = new ArrayList<Header>();
            }
            this.headers.add(new Header(key, values));
            return this;
        }

        public SimpleHttpResponseMessageBuilder headers(Map<String, Object> headers2) {
            headers2.forEach((k, v) -> this.header((String)k, String.valueOf(v)));
            return this;
        }

        public SimpleHttpResponseMessageBuilder status(int status) {
            this.status = status;
            return this;
        }

        public SimpleHttpResponseMessageBuilder contentType(MediaType contentType2) {
            this.contentType = contentType2;
            return this;
        }

        public SimpleHttpResponseMessageBuilder headers(List<Header> headers2) {
            this.headers = headers2;
            return this;
        }

        public SimpleHttpResponseMessageBuilder payload(ByteBuf payload) {
            this.payload = payload;
            return this;
        }

        public SimpleHttpResponseMessage build() {
            if (this.payload == null) {
                this.payload = Unpooled.wrappedBuffer(new byte[0]);
            }
            return new SimpleHttpResponseMessage(this.status, this.contentType, this.headers, this.payload);
        }

        public String toString() {
            return "SimpleHttpResponseMessage.SimpleHttpResponseMessageBuilder(status=" + this.status + ", contentType=" + this.contentType + ", headers=" + this.headers + ", payload=" + this.payload + ")";
        }
    }
}

