/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;
import org.jetlinks.core.message.codec.DefaultCoapResponseMessage;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.springframework.util.CollectionUtils;

public interface CoapResponseMessage
extends EncodedMessage {
    @Nonnull
    public CoAP.ResponseCode getCode();

    @Nullable
    public List<Option> getOptions();

    @Nonnull
    default public Optional<Option> getOption(int number) {
        return Optional.ofNullable(this.getOptions()).flatMap(list -> list.stream().filter(opt -> opt.getNumber() == number).findFirst());
    }

    @Nonnull
    default public Optional<String> getStringOption(int number) {
        return this.getOption(number).map(Option::getStringValue);
    }

    @Nonnull
    default public Optional<Integer> getIntOption(int number) {
        return this.getOption(number).map(Option::getIntegerValue);
    }

    default public String print(boolean pretty) {
        StringBuilder builder = new StringBuilder().append(this.getCode().name()).append(" ").append(this.getCode().toString()).append("\n");
        if (!CollectionUtils.isEmpty(this.getOptions())) {
            for (Option option : this.getOptions()) {
                builder.append(option).append("\n");
            }
        }
        builder.append("\n");
        ByteBuf byteBuf = this.getPayload();
        if (this.getOption(12).isPresent()) {
            builder.append(byteBuf.toString(StandardCharsets.UTF_8));
        } else if (pretty) {
            ByteBufUtil.appendPrettyHexDump(builder, this.getPayload());
        } else {
            builder.append(Hex.encodeHex(this.payloadAsBytes()));
        }
        return builder.toString();
    }

    public static CoapResponseMessage fromText(String text) {
        return DefaultCoapResponseMessage.of(text);
    }

    public static CoapResponseMessage fromResponse(CoapResponse response) {
        return DefaultCoapResponseMessage.of(response);
    }
}

