/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import java.io.Externalizable;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.collections.MapUtils;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.core.utils.ConverterUtils;

public interface Message
extends Jsonable,
Externalizable {
    default public MessageType getMessageType() {
        return MessageType.UNKNOWN;
    }

    public String getMessageId();

    public long getTimestamp();

    @Nullable
    public Map<String, Object> getHeaders();

    public Message addHeader(String var1, Object var2);

    public Message addHeaderIfAbsent(String var1, Object var2);

    public Message removeHeader(String var1);

    default public <T> Message addHeader(HeaderKey<T> header, T value) {
        return this.addHeader(header.getKey(), value);
    }

    default public <T> Message addHeaderIfAbsent(HeaderKey<T> header, T value) {
        return this.addHeaderIfAbsent(header.getKey(), value);
    }

    default public <T> T getOrAddHeader(HeaderKey<T> header, Supplier<T> value) {
        return (T)this.computeHeader(header, (String ignore, T old) -> {
            if (old == null) {
                old = value.get();
            }
            return old;
        });
    }

    default public <T> T getOrAddHeaderDefault(HeaderKey<T> header) {
        return (T)this.getOrAddHeader(header, header::getDefaultValue);
    }

    default public <T> Optional<T> getHeader(HeaderKey<T> key) {
        return Optional.ofNullable(this.getHeaderOrElse(key, null));
    }

    default public <T> T getHeaderOrDefault(HeaderKey<T> key) {
        return (T)this.getHeaderOrElse(key, key::getDefaultValue);
    }

    default public <T> T getHeaderOrElse(HeaderKey<T> header, @Nullable Supplier<T> orElse) {
        Object val = this.getHeaderOrElse(header.getKey(), null);
        if (null == val) {
            return orElse == null ? null : (T)orElse.get();
        }
        return ConverterUtils.convert(val, header);
    }

    default public Object getHeaderOrElse(String header, @Nullable Supplier<Object> orElse) {
        Map<String, Object> headers2 = this.getHeaders();
        if (MapUtils.isEmpty(headers2) || header == null) {
            return orElse == null ? null : orElse.get();
        }
        Object val = headers2.get(header);
        if (val != null) {
            return val;
        }
        return orElse == null ? null : orElse.get();
    }

    default public Optional<Object> getHeader(String header) {
        return Optional.ofNullable(this.getHeaderOrElse(header, null));
    }

    public Object computeHeader(String var1, BiFunction<String, Object, Object> var2);

    default public <T> T computeHeader(HeaderKey<T> key, BiFunction<String, T, T> computer) {
        return (T)this.computeHeader(key.getKey(), (String str, Object old) -> computer.apply((String)str, (Object)(old == null ? null : (Object)ConverterUtils.convert(old, key))));
    }

    default public void validate() {
    }

    default public Message copy() {
        return (Message)FastBeanCopier.copy(this, this.getClass(), new String[0]);
    }
}

