/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.message.CommonThingMessage;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.UpdateTingTagsMessage;

public class DefaultUpdateTingTagsMessage
extends CommonThingMessage<DefaultUpdateTingTagsMessage>
implements UpdateTingTagsMessage {
    private Map<String, Object> tags;

    @Override
    public Map<String, Object> getTags() {
        return this.tags == null ? Collections.emptyMap() : this.tags;
    }

    public DefaultUpdateTingTagsMessage tag(String tag, Object value) {
        if (this.tags == null) {
            this.tags = new ConcurrentHashMap<String, Object>();
        }
        this.tags.put(tag, value);
        return this;
    }

    @Override
    public DefaultUpdateTingTagsMessage tags(Map<String, Object> tags) {
        if (tags == null) {
            return this;
        }
        if (this.tags == null) {
            this.tags = new ConcurrentHashMap<String, Object>(tags);
            return this;
        }
        this.tags.putAll(tags);
        return this;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.UPDATE_TAG;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.tags = jsonObject.getJSONObject("tags");
    }

    public void setTags(Map<String, Object> tags) {
        this.tags = tags;
    }
}

