/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.event;

import java.util.function.Function;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codecs;
import org.jetlinks.core.codec.Decoder;
import org.jetlinks.core.codec.Encoder;
import org.jetlinks.core.codec.defaults.DirectCodec;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.core.event.TopicPayload;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public interface EventBus {
    public Flux<TopicPayload> subscribe(Subscription var1);

    default public Disposable subscribe(Subscription subscription, Function<TopicPayload, Mono<Void>> handler) {
        return this.subscribe(subscription).flatMap(handler).subscribe();
    }

    public <T> Flux<T> subscribe(Subscription var1, Decoder<T> var2);

    public <T> Mono<Long> publish(String var1, Publisher<T> var2);

    public <T> Mono<Long> publish(String var1, Encoder<T> var2, Publisher<? extends T> var3);

    public <T> Mono<Long> publish(String var1, Encoder<T> var2, Publisher<? extends T> var3, Scheduler var4);

    default public <T> Flux<T> subscribe(Subscription subscription, Class<T> type) {
        return this.subscribe(subscription, Codecs.lookup(type));
    }

    default public <T> Mono<Long> publish(String topic, Encoder<T> encoder, T event) {
        return this.publish(topic, encoder, (T)Mono.just(event));
    }

    default public <T> Mono<Long> publish(String topic, Encoder<T> encoder, T event, Scheduler scheduler) {
        return this.publish(topic, encoder, (T)Mono.just(event), scheduler);
    }

    default public <T> Mono<Long> publish(String topic, T event) {
        if (event instanceof Payload) {
            return this.publish(topic, (Payload)event);
        }
        return this.publish(topic, Codecs.lookup(event.getClass()), event);
    }

    default public <T> Mono<Long> publish(String topic, T event, Scheduler scheduler) {
        if (event instanceof Payload) {
            return this.publish(topic, (Payload)event, scheduler);
        }
        return this.publish(topic, Codecs.lookup(event.getClass()), event, scheduler);
    }

    @Deprecated
    default public Mono<Long> publish(String topic, Payload event) {
        return this.publish(topic, DirectCodec.INSTANCE, event);
    }

    @Deprecated
    default public Mono<Long> publish(String topic, Payload event, Scheduler scheduler) {
        return this.publish(topic, DirectCodec.INSTANCE, event, scheduler);
    }
}

