/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.defaults;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.ProtocolSupports;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.config.ConfigStorage;
import org.jetlinks.core.config.ConfigStorageManager;
import org.jetlinks.core.config.StorageConfigurable;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.DeviceMetadataCodec;
import org.jetlinks.core.things.ThingMetadata;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultDeviceProductOperator
implements DeviceProductOperator,
StorageConfigurable {
    private final String id;
    private volatile DeviceMetadata metadata;
    private final Mono<ConfigStorage> storageMono;
    private final Supplier<Flux<DeviceOperator>> devicesSupplier;
    private long lstMetadataChangeTime;
    private static final ConfigKey<Long> lastMetadataTimeKey = ConfigKey.of("lst_metadata_time");
    private final Mono<DeviceMetadata> inLocalMetadata;
    private final Mono<DeviceMetadata> metadataMono;
    private final Mono<ProtocolSupport> protocolSupportMono;

    @Deprecated
    public DefaultDeviceProductOperator(String id, ProtocolSupports supports, ConfigStorageManager manager) {
        this(id, supports, manager, Flux::empty);
    }

    public DefaultDeviceProductOperator(String id, ProtocolSupports supports, ConfigStorageManager manager, Supplier<Flux<DeviceOperator>> supplier) {
        this(id, supports, manager.getStorage("device-product:".concat(id)), supplier);
    }

    public DefaultDeviceProductOperator(String id, ProtocolSupports supports, Mono<ConfigStorage> storageMono, Supplier<Flux<DeviceOperator>> supplier) {
        this.id = id;
        this.storageMono = storageMono;
        this.devicesSupplier = supplier;
        this.inLocalMetadata = Mono.fromSupplier(() -> this.metadata);
        this.protocolSupportMono = this.getConfig(DeviceConfigKey.protocol).flatMap(supports::getProtocol);
        Mono loadMetadata = Mono.zip(this.getProtocol().map(ProtocolSupport::getMetadataCodec), this.getConfig(DeviceConfigKey.metadata), this.getConfig(lastMetadataTimeKey).switchIfEmpty(Mono.defer(() -> {
            long now = System.currentTimeMillis();
            return this.setConfig(lastMetadataTimeKey, now).thenReturn(now);
        }))).flatMap(tp3 -> ((DeviceMetadataCodec)tp3.getT1()).decode((String)tp3.getT2()).doOnNext(decode -> {
            this.metadata = decode;
            this.lstMetadataChangeTime = (Long)tp3.getT3();
        }));
        this.metadataMono = this.getConfig(lastMetadataTimeKey).flatMap(time -> {
            if (time.equals(this.lstMetadataChangeTime)) {
                return this.inLocalMetadata;
            }
            return Mono.empty();
        }).switchIfEmpty(loadMetadata);
    }

    @Override
    public Mono<DeviceMetadata> getMetadata() {
        return this.metadataMono;
    }

    @Override
    public Mono<Boolean> updateMetadata(ThingMetadata metadata) {
        if (metadata instanceof DeviceMetadata) {
            return this.getProtocol().flatMap(protocol -> protocol.getMetadataCodec().encode((DeviceMetadata)metadata)).flatMap(this::updateMetadata);
        }
        return Mono.just(false);
    }

    @Override
    public Mono<Boolean> setConfigs(Map<String, Object> conf) {
        if (conf.containsKey(DeviceConfigKey.metadata.getKey())) {
            conf.put(lastMetadataTimeKey.getKey(), System.currentTimeMillis());
            return StorageConfigurable.super.setConfigs(conf).doOnNext(s2 -> {
                this.metadata = null;
            }).then(this.getProtocol().flatMap(support -> support.onProductMetadataChanged(this))).thenReturn(true);
        }
        return StorageConfigurable.super.setConfigs(conf);
    }

    @Override
    public Mono<Boolean> updateMetadata(String metadata) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put(DeviceConfigKey.metadata.getKey(), metadata);
        return this.setConfigs(configs);
    }

    @Override
    public Mono<ProtocolSupport> getProtocol() {
        return this.protocolSupportMono;
    }

    @Override
    public Mono<ConfigStorage> getReactiveStorage() {
        return this.storageMono;
    }

    @Override
    public Flux<DeviceOperator> getDevices() {
        return this.devicesSupplier == null ? Flux.empty() : this.devicesSupplier.get();
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected Mono<ConfigStorage> getStorageMono() {
        return this.storageMono;
    }
}

