/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.codec.defaults;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;

public class StringCodec
implements Codec<String> {
    public static StringCodec DEFAULT = StringCodec.of(Charset.defaultCharset());
    public static StringCodec UTF8 = StringCodec.of(StandardCharsets.UTF_8);
    public static StringCodec ASCII = StringCodec.of(StandardCharsets.US_ASCII);
    private final Charset charset;

    public static StringCodec of(Charset charset) {
        return new StringCodec(charset);
    }

    private StringCodec(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Class<String> forType() {
        return String.class;
    }

    @Override
    public String decode(@Nonnull Payload payload) {
        return payload.getBody().toString(this.charset);
    }

    @Override
    public Payload encode(String body2) {
        return Payload.of(body2.getBytes(this.charset));
    }
}

