/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.cache;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.jetlinks.core.cache.FileQueue;
import org.jetlinks.core.cache.FileQueueBuilderFactory;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.config.ConfigKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SPIFileQueueBuilder<T>
implements FileQueue.Builder<T> {
    private static final Logger log = LoggerFactory.getLogger(SPIFileQueueBuilder.class);
    final FileQueue.Builder<T> builder = factory.create();
    private static final FileQueueBuilderFactory factory;

    SPIFileQueueBuilder() {
    }

    @Override
    public FileQueue<T> build() {
        return this.builder.build();
    }

    @Override
    public FileQueue.Builder<T> codec(Codec<T> codec) {
        return this.builder.codec(codec);
    }

    @Override
    public FileQueue.Builder<T> path(Path path2) {
        return this.builder.path(path2);
    }

    @Override
    public FileQueue.Builder<T> options(Map<String, Object> options) {
        return this.builder.options(options);
    }

    @Override
    public FileQueue.Builder<T> option(String key, Object value) {
        return this.builder.option(key, value);
    }

    @Override
    public <V> FileQueue.Builder<T> option(ConfigKey<V> key, V value) {
        return this.builder.option(key, value);
    }

    @Override
    public FileQueue.Builder<T> name(String name) {
        return this.builder.name(name);
    }

    static {
        ServiceLoader<FileQueueBuilderFactory> loader = ServiceLoader.load(FileQueueBuilderFactory.class, SPIFileQueueBuilder.class.getClassLoader());
        Iterator<FileQueueBuilderFactory> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            log.warn("Cant not load service [FileQueueBuilderFactory]");
            factory = new FileQueueBuilderFactory(){

                @Override
                public <T> FileQueue.Builder<T> create() {
                    throw new UnsupportedOperationException("unsupported service FileQueueBuilderFactory");
                }
            };
        } else {
            factory = iterator.next();
            log.debug("Load service [FileQueueBuilderFactory] : [{}]", (Object)factory.getClass());
        }
    }
}

