import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        {
            title: '联系人',
            prop: 'companyContact',
            type: 'input',
            value: ''
        },
        {
            title: '联系电话',
            prop: 'contactTel',
            type: 'input',
            value: ''
        },
        {
            title: '成立日期',
            prop: 'companyRegdate',
            type: 'date',
            dateOption: {
                type: 'daterange',
                format: 'YYYY-MM-DD',
                valueFormat: 'YYYY-MM-DD'
            },
            span: 6,
            value: []
        },
        {
            title: '签署状态',
            prop: 'auditStatus',
            type: 'select',
            multiple: true,
            options: getDictionaryByCode('qyxyqszt'),
            value: []
        }
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '供方名称',
            prop: 'companyCode',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '类别',
            prop: 'regisType',
            type: 'select',
            multiple: true,
            options: [
                { name: '企业', value: '0' },
                { name: '个人', value: '1' }
            ],
            value: [],
            span: 4
        },
        {
            title: '状态',
            prop: 'isTempEnterprise',
            type: 'select',
            multiple: true,
            options: [
                { name: '否', value: '0' },
                { name: '是', value: '1' }
            ],
            value: [],
            span: 4
        },
        {
            title: '申请时间',
            prop: 'createTime',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 6,
            value: []
        }
    ]
    const columnsList: COption[] = [
        {
            title: '企业名称',
            prop: 'gfmc',
            minWidth: 180,
            sortable: true
        },
        {
            title: '考核年度',
            prop: 'lb',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '考核月度',
            prop: 'lb',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '已考核供应商',
            prop: 'gycp',
            minWidth: 120,
            sortable: true
        },
        {
            title: '未考核供应商',
            prop: 'zczj',
            minWidth: 120,
            sortable: true
        },
        {
            title: '优秀',
            prop: 'status',
            minWidth: 120,
            sortable: true
        },
        {
            title: '良好',
            prop: 'time',
            minWidth: 120,
            sortable: true
        },
        {
            title: '合格',
            prop: 'time',
            minWidth: 120,
            sortable: true
        },
        {
            title: '可改善',
            prop: 'time',
            minWidth: 120,
            sortable: true
        },
        {
            title: '不合格',
            prop: 'time',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
