import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterpriseAccess/v1/queryPage`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 表格回显
export function dataDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseAccess/v1/getInfo/${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 导出excel
export function exportData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .download('/biz/enterprise/exportDataToExcel', 'post', data, 'arraybuffer')
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 保存审核
export function auditData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterpriseAccess/v1/saveOrUpdateOtherInfo`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 评分人员列表
export function getOrgUserList(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseAccess/v1/getTrialReportPanel?id=${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 提交审核
export function audit(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post('/bizSupplierEnterpriseAccess/v1/audit', data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 审批日志
export function approvalLog(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseAccess/v1/queryApprovalLogs?id=${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 获取申请左边菜单列表
export function getFillingProgress(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseAccess/v1/getFillingProgress?id=${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
