/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ueditor.hunter;

import com.artfess.base.util.AppUtil;
import com.artfess.ueditor.PathFormat;
import com.artfess.ueditor.define.BaseState;
import com.artfess.ueditor.define.MIMEType;
import com.artfess.ueditor.define.MultiState;
import com.artfess.ueditor.define.State;
import com.artfess.ueditor.upload.StorageService;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ImageHunter {
    @Autowired
    private StorageService storageService;
    private String filename = null;
    private String savePath = null;
    private String rootPath = null;
    private List<String> allowTypes = null;
    private long maxSize = -1L;
    private List<String> filters = null;

    public ImageHunter(Map<String, Object> conf) {
        this.filename = (String)conf.get("filename");
        this.savePath = (String)conf.get("savePath");
        this.rootPath = (String)conf.get("rootPath");
        this.maxSize = (Long)conf.get("maxSize");
        this.allowTypes = Arrays.asList((String[])conf.get("allowFiles"));
        this.filters = Arrays.asList((String[])conf.get("filter"));
    }

    public State capture(String[] list) {
        MultiState state = new MultiState(true);
        for (String source : list) {
            state.addState(this.captureRemoteData(source));
        }
        return state;
    }

    public State captureRemoteData(String urlStr) {
        HttpURLConnection connection = null;
        URL url = null;
        String suffix = null;
        try {
            State state;
            url = new URL(urlStr);
            if (!this.validHost(url.getHost())) {
                return new BaseState(false, 201);
            }
            connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(true);
            connection.setUseCaches(true);
            if (!this.validContentState(connection.getResponseCode())) {
                return new BaseState(false, 202);
            }
            suffix = MIMEType.getSuffix(connection.getContentType());
            if (!this.validFileType(suffix)) {
                return new BaseState(false, 8);
            }
            if (!this.validFileSize(connection.getContentLength())) {
                return new BaseState(false, 1);
            }
            if (this.storageService == null) {
                this.storageService = (StorageService)AppUtil.getBean(StorageService.class);
            }
            if ((state = this.storageService.saveFileByInputStream(connection.getInputStream(), urlStr)).isSuccess()) {
                state.putInfo("source", urlStr);
            }
            return state;
        }
        catch (Exception e) {
            return new BaseState(false, 203);
        }
    }

    private String getPath(String savePath, String filename, String suffix) {
        return PathFormat.parse(savePath + suffix, filename);
    }

    private boolean validHost(String hostname) {
        return !this.filters.contains(hostname);
    }

    private boolean validContentState(int code) {
        return 200 == code;
    }

    private boolean validFileType(String type) {
        return this.allowTypes.contains(type);
    }

    private boolean validFileSize(int size) {
        return (long)size < this.maxSize;
    }
}

