/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.service.ws.cxf;

import com.artfess.base.service.InvokeCmd;
import com.artfess.base.service.InvokeResult;
import com.artfess.service.model.DefaultInvokeResult;
import com.artfess.service.ws.WebServiceClient;
import com.artfess.service.ws.cxf.invok.CxfInvokService;
import com.artfess.service.ws.cxf.parse.CxfParseService;
import com.artfess.service.ws.model.SoapService;
import com.artfess.service.ws.security.AuthInfoContext;
import java.io.File;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class CxfDynamicWebServiceParse
implements WebServiceClient {
    @Resource
    private CxfParseService parseService;
    @Resource
    private CxfInvokService invokeService;
    private static final Log logger = LogFactory.getLog(CxfDynamicWebServiceParse.class);

    @Override
    public SoapService parse(String wsdlPath) {
        return this.parseService.parse(wsdlPath);
    }

    @Override
    public SoapService parse(String wsdlPath, String username, String password) {
        this.setAuthInfo(username, password);
        return this.parseService.parse(wsdlPath);
    }

    @Override
    public SoapService parse(File wsdlFile) {
        return this.parseService.parse(wsdlFile);
    }

    @Override
    public SoapService parse(File wsdlFile, String username, String password) {
        this.setAuthInfo(username, password);
        return this.parseService.parse(wsdlFile);
    }

    private void setAuthInfo(String username, String password) {
        if (username != null) {
            AuthInfoContext.setProperty("auth_username", username);
            AuthInfoContext.setProperty("auth_password", password);
        }
    }

    @Override
    public InvokeResult invoke(InvokeCmd invokeCmd) {
        try {
            return this.invokeService.invoke(invokeCmd);
        }
        catch (Exception e) {
            logger.error((Object)e);
            DefaultInvokeResult result = new DefaultInvokeResult();
            result.setException(e);
            return result;
        }
    }
}

