/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.service.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.service.InvokeResult;
import com.artfess.base.service.ServiceClient;
import com.artfess.service.manager.ServiceSetManager;
import com.artfess.service.model.ServiceSet;
import com.artfess.service.parse.ServiceBean;
import com.artfess.service.parse.ServiceParser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/service/set/v1/"})
@Api(tags={"\u670d\u52a1\u8c03\u7528\u8bbe\u7f6e"})
@ApiGroup(group={"group_system"})
public class ServiceSetController {
    @Resource
    ServiceParser serviceParser;
    @Resource
    ServiceSetManager serviceSetManager;
    @Resource
    ServiceClient serviceClient;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u8c03\u7528\u8bbe\u7f6e\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u670d\u52a1\u8c03\u7528\u8bbe\u7f6e\u5217\u8868")
    public PageList<ServiceSet> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.serviceSetManager.query(queryFilter);
    }

    @RequestMapping(value={"parser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u89e3\u6790WebService", httpMethod="POST", notes="\u89e3\u6790WebService\u8be6\u60c5")
    public ServiceBean parser(@ApiParam(name="wsdlUrl", value="WebService\u7684wsdl\u5730\u5740", required=true) @RequestParam String wsdlUrl) throws Exception {
        return this.serviceParser.parse(wsdlUrl);
    }

    @RequestMapping(value={"detail"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u8c03\u7528\u8bbe\u7f6e\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6\u670d\u52a1\u8c03\u7528\u8bbe\u7f6e\u8be6\u60c5")
    public ServiceSet detail(@ApiParam(name="alias", value="\u670d\u52a1\u8bbe\u7f6e\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        return this.serviceSetManager.getByAlias(alias);
    }

    @RequestMapping(value={"invoke"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u8bbe\u7f6e\u522b\u540d\u8c03\u7528\u670d\u52a1", httpMethod="POST", notes="\u901a\u8fc7\u8bbe\u7f6e\u522b\u540d\u8c03\u7528\u670d\u52a1")
    public InvokeResult invoke(@ApiParam(name="alias", value="\u670d\u52a1\u8bbe\u7f6e\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="map", value="\u8c03\u7528\u53c2\u6570") @RequestBody Map<String, Object> map) throws Exception {
        return this.serviceClient.invoke(alias, map);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u670d\u52a1\u8c03\u7528\u8bbe\u7f6e", httpMethod="POST", notes="\u4fdd\u5b58\u670d\u52a1\u8c03\u7528\u8bbe\u7f6e")
    public CommonResult<String> save(@ApiParam(name="serviceSet", value="\u670d\u52a1\u8c03\u7528\u8bbe\u7f6e", required=true) @RequestBody ServiceSet serviceSet) throws Exception {
        this.serviceSetManager.saveData(serviceSet);
        return new CommonResult("\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"removes"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664bo\u5b9a\u4e49", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664bo\u5b9a\u4e49")
    public CommonResult<String> batchRemove(String ... ids) throws Exception {
        this.serviceSetManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }
}

