/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.integrate.util;

import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.integrate.consts.WeChatWorkConsts;
import com.artfess.integrate.model.TokenModel;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatWorkTokenUtil {
    protected static Logger log = LoggerFactory.getLogger(WechatWorkTokenUtil.class);
    private static TokenModel model = new TokenModel();
    private static TokenModel agentModel = new TokenModel();

    public static synchronized String getToken() throws IOException {
        if (!model.isInit()) {
            String token = WechatWorkTokenUtil.requestToken();
            return token;
        }
        if (model.isExpire(model.getLastUpdTime(), model.getExprieIn())) {
            String token = WechatWorkTokenUtil.requestToken();
            return token;
        }
        return model.getToken();
    }

    private static String requestToken() throws IOException {
        String url = WeChatWorkConsts.getTokenUrl();
        String rtn = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"GET");
        JsonNode jsonObj = JsonUtil.toJsonNode((String)rtn);
        System.out.println(rtn);
        if (jsonObj.get("errcode").asInt() == 0) {
            String token = jsonObj.get("access_token").asText();
            int expireIn = jsonObj.get("expires_in").asInt();
            model.setCorpToken(token, expireIn);
            return token;
        }
        model.setInit(false);
        String errMsg = jsonObj.get("errmsg").asText();
        log.error(errMsg);
        throw new RuntimeException("\u83b7\u53d6accessToken\u5931\u8d25:<br>" + errMsg);
    }

    public static synchronized String getAgentToken() throws IOException {
        if (!agentModel.isInit()) {
            String token = WechatWorkTokenUtil.requestAgentToken();
            return token;
        }
        if (agentModel.isExpire(agentModel.getLastUpdTime(), agentModel.getExprieIn())) {
            String token = WechatWorkTokenUtil.requestAgentToken();
            return token;
        }
        return agentModel.getToken();
    }

    private static String requestAgentToken() throws IOException {
        String url = WeChatWorkConsts.getAgentToKenUrl();
        String rtn = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"GET");
        JsonNode jsonObj = JsonUtil.toJsonNode((String)rtn);
        System.out.println(rtn);
        if (jsonObj.get("errcode").asInt() == 0) {
            String token = jsonObj.get("access_token").asText();
            int expireIn = jsonObj.get("expires_in").asInt();
            agentModel.setCorpToken(token, expireIn);
            return token;
        }
        agentModel.setInit(false);
        String errMsg = jsonObj.get("errmsg").asText();
        log.error(errMsg);
        throw new RuntimeException("\u83b7\u53d6accessToken\u5931\u8d25:<br>" + errMsg);
    }
}

