/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.util;

import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import com.obs.services.exception.ObsException;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.ProgressListener;
import com.obs.services.model.ProgressStatus;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class HuaweiyunOssUtil {
    private static final Logger log = LoggerFactory.getLogger(HuaweiyunOssUtil.class);
    private static String ak;
    private static String sk;
    private static String bucketName;
    private static String endpoint;
    private static ObsClient obsClient;

    public static String getAk() {
        return ak;
    }

    public static void setAk(String ak) {
        HuaweiyunOssUtil.ak = ak;
    }

    public static String getSk() {
        return sk;
    }

    public static void setSk(String sk) {
        HuaweiyunOssUtil.sk = sk;
    }

    public static String getBucketName() {
        return bucketName;
    }

    public static void setBucketName(String bucketName) {
        HuaweiyunOssUtil.bucketName = bucketName;
    }

    public static String getEndpoint() {
        return endpoint;
    }

    public static void setEndpoint(String endpoint) {
        HuaweiyunOssUtil.endpoint = endpoint;
    }

    public static String uploadFile(String path) {
        try {
            HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
            File file = new File(path);
            FileInputStream fis = new FileInputStream(file);
            PutObjectResult response = obsClient.putObject(bucketName, file.getName(), (InputStream)fis);
            int statusCode = response.getStatusCode();
            if (200 == statusCode) {
                return response.getObjectUrl();
            }
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return "";
    }

    public static String uploadFile(MultipartFile file, String filePath) {
        try {
            HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
            PutObjectRequest request = new PutObjectRequest(bucketName, filePath, file.getInputStream());
            PutObjectResult response = obsClient.putObject(request);
            int statusCode = response.getStatusCode();
            if (200 == statusCode) {
                return response.getObjectUrl();
            }
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return "";
    }

    public static String uploadFile(String fileName, InputStream is) {
        try {
            HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
            PutObjectResult response = obsClient.putObject(bucketName, fileName, is);
            int statusCode = response.getStatusCode();
            is.close();
            if (200 == statusCode) {
                return response.getObjectUrl();
            }
        }
        catch (ObsException e) {
            System.out.println("HTTP Code: " + e.getResponseCode());
            System.out.println("Error Code:" + e.getErrorCode());
            System.out.println("Request ID:" + e.getErrorRequestId());
            e.printStackTrace(System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static byte[] Download(String fileName, OutputStream out) throws IOException {
        int len;
        HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
        ObsObject obsObject = obsClient.getObject(bucketName, fileName);
        InputStream input = obsObject.getObjectContent();
        byte[] b = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = input.read(b)) != -1) {
            out.write(b, 0, len);
        }
        out.close();
        input.close();
        return bos.toByteArray();
    }

    public void downloadFile(String objectKey, HttpServletResponse response) throws IOException {
        HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
        ObsObject obsObject = obsClient.getObject(bucketName, objectKey);
        try (InputStream input = obsObject.getObjectContent();
             ServletOutputStream output = response.getOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
            output.flush();
        }
    }

    public static void DownloadChange(String fileName) throws IOException {
        int len;
        HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
        GetObjectRequest request = new GetObjectRequest(bucketName, fileName);
        request.setProgressListener(new ProgressListener(){

            public void progressChanged(ProgressStatus status) {
                System.out.println("AverageSpeed:" + status.getAverageSpeed());
                System.out.println("TransferPercentage:" + status.getTransferPercentage());
            }
        });
        request.setProgressInterval(0x100000L);
        ObsObject obsObject = obsClient.getObject(request);
        System.out.println(obsObject.toString());
        InputStream input = obsObject.getObjectContent();
        byte[] b = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = input.read(b)) != -1) {
            bos.write(b, 0, len);
        }
        System.out.println(new String(bos.toByteArray()));
        bos.close();
        input.close();
    }

    public static String getDownloadUrl(String fileName) {
        HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
        long expireSeconds = 3600L;
        TemporarySignatureRequest request = new TemporarySignatureRequest(HttpMethodEnum.GET, expireSeconds);
        request.setBucketName(bucketName);
        request.setObjectKey(fileName);
        TemporarySignatureResponse response = obsClient.createTemporarySignature(request);
        return response.getSignedUrl();
    }

    public static boolean chekckFile(String fileName) {
        HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
        ObjectMetadata metadata = obsClient.getObjectMetadata(bucketName, fileName);
        return metadata != null;
    }

    public static boolean deleteFile(String fileName) {
        try {
            HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
            obsClient.deleteObject(bucketName, fileName);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static ObsClient initObsClient(String ak, String sk, String endpoint) {
        if (obsClient == null) {
            ObsConfiguration config = new ObsConfiguration();
            config.setSocketTimeout(30000);
            config.setConnectionTimeout(10000);
            config.setEndPoint(endpoint);
            obsClient = new ObsClient(ak, sk, config);
        }
        return obsClient;
    }

    static {
        obsClient = null;
    }
}

