/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.util;

import com.artfess.base.jms.JmsActor;
import com.artfess.base.jms.JmsProducer;
import com.artfess.base.jms.Notice;
import com.artfess.base.jms.NoticeMessageType;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.event.NodeNotifyModel;
import com.artfess.bpm.api.event.NotifyTaskModel;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.util.BpmUtil;
import com.artfess.bpm.util.PortalDataUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageUtil {
    public static Map<String, String> getHandlerTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        EnumSet<NoticeMessageType> it = EnumSet.allOf(NoticeMessageType.class);
        for (NoticeMessageType type : it) {
            map.put(type.key(), type.label());
        }
        return map;
    }

    public static boolean isSupportHtml(String notifyType) {
        EnumSet<NoticeMessageType> it = EnumSet.allOf(NoticeMessageType.class);
        for (NoticeMessageType type : it) {
            if (!type.key().equals(notifyType)) continue;
            return type.isPlain() == false;
        }
        return false;
    }

    public static NoticeMessageType[] parseNotifyType(List<String> nofifyTypes) {
        ArrayList<NoticeMessageType> messageTypeArrays = new ArrayList<NoticeMessageType>();
        EnumSet<NoticeMessageType> it = EnumSet.allOf(NoticeMessageType.class);
        for (NoticeMessageType type : it) {
            if (nofifyTypes.indexOf(type.key()) <= -1) continue;
            messageTypeArrays.add(type);
        }
        NoticeMessageType[] messageTypes = new NoticeMessageType[messageTypeArrays.size()];
        messageTypeArrays.toArray(messageTypes);
        return messageTypes;
    }

    public static NoticeMessageType[] parseNotifyType(String notifyType) {
        if (notifyType == null) {
            notifyType = "";
        }
        String[] arys = notifyType.split(",");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arys));
        return MessageUtil.parseNotifyType(list);
    }

    public static String[] parseAccountOfUser(List<IUser> users) {
        ArrayList<String> receiverAccounts = new ArrayList<String>();
        for (IUser receiver : users) {
            if (StringUtil.isEmpty((String)receiver.getAccount()) && StringUtil.isNotEmpty((String)receiver.getUserId())) {
                receiverAccounts.add(receiver.getUserId());
                continue;
            }
            receiverAccounts.add(receiver.getAccount());
        }
        String[] receivers = new String[receiverAccounts.size()];
        receiverAccounts.toArray(receivers);
        return receivers;
    }

    public static void notify(DefaultBpmTask bpmTask, String opinion, IUser receiver, String notifyType, String typeKey) throws Exception {
        if (BeanUtils.isNotEmpty((Object)bpmTask) && StringUtil.isEmpty((String)notifyType)) {
            notifyType = BpmUtil.getNotifyType(bpmTask);
        }
        NotifyTaskModel model = new NotifyTaskModel();
        String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
        model.addVars("baseUrl", baseUrl).addVars("taskSubject", bpmTask.getSubject()).addVars("instSubject", bpmTask.getSubject()).addVars("taskId", bpmTask.getId()).addVars("nodeName", bpmTask.getName()).addVars("cause", opinion).addVars("nodeName", bpmTask.getName()).addVars("receiverId", receiver.getUserId()).addVars("receiver", receiver.getFullname());
        ArrayList<IUser> identitys = new ArrayList<IUser>();
        identitys.add(receiver);
        model.setIdentitys(identitys);
        MessageUtil.send(model, notifyType, typeKey);
    }

    public static void send(NotifyTaskModel model, String notifyType, String typeKey) throws Exception {
        List<IUser> userList = model.getIdentitys();
        MessageUtil.sendMsg(typeKey, notifyType, userList, model.getVars());
    }

    public static void sendMsg(NodeNotifyModel model, String notifyType, String typeKey) throws Exception {
        NoticeMessageType[] messageTypes = MessageUtil.parseNotifyType(notifyType);
        List<JmsActor> recieverAccounts = model.getJmsActors();
        IUser sender = ContextUtil.getCurrentUser();
        Map<String, Object> vars = model.getVars();
        vars.put("sender", BeanUtils.isNotEmpty((Object)sender) ? sender.getFullname() : "\u7cfb\u7edf\u6267\u884c\u4eba");
        vars.put("senderId", BeanUtils.isNotEmpty((Object)sender) ? sender.getUserId() : "-1");
        if (recieverAccounts.size() == 1) {
            vars.put("receiver", recieverAccounts.get(0).getAccount());
        }
        Notice notice = new Notice();
        notice.setSubject(model.getSubject());
        notice.setContent(model.getContent());
        notice.setUseTemplate(false);
        notice.setMessageTypes(messageTypes);
        notice.setSender(sender.getAccount());
        notice.setTemplateType(typeKey);
        notice.setVars(vars);
        notice.setReceiver(recieverAccounts);
        JmsProducer jmsProducer = (JmsProducer)AppUtil.getBean(JmsProducer.class);
        jmsProducer.sendToQueue((Object)notice);
    }

    public static void sendMsg(String typeKey, String notifyType, List<IUser> recievers, Map<String, Object> vars) throws Exception {
        NoticeMessageType[] messageTypes = MessageUtil.parseNotifyType(notifyType);
        List<JmsActor> recieverAccounts = MessageUtil.parseJmsActor(recievers);
        IUser sender = ContextUtil.getCurrentUser();
        vars.put("sender", BeanUtils.isNotEmpty((Object)sender) ? sender.getFullname() : "\u7cfb\u7edf\u6267\u884c\u4eba");
        vars.put("senderId", BeanUtils.isNotEmpty((Object)sender) ? sender.getUserId() : "-1");
        if (recievers.size() == 1) {
            vars.put("receiver", recievers.get(0).getFullname());
        }
        Notice notice = new Notice();
        notice.setUseTemplate(true);
        notice.setMessageTypes(messageTypes);
        notice.setSender(sender.getAccount());
        notice.setTemplateType(typeKey);
        notice.setVars(vars);
        notice.setReceiver(recieverAccounts);
        JmsProducer jmsProducer = (JmsProducer)AppUtil.getBean(JmsProducer.class);
        jmsProducer.sendToQueue((Object)notice);
    }

    public static List<JmsActor> parseJmsActor(List<IUser> users) {
        ArrayList<JmsActor> actors = new ArrayList<JmsActor>();
        for (IUser user : users) {
            JmsActor actor = new JmsActor();
            actor.setId(user.getUserId());
            actor.setAccount(user.getAccount());
            actor.setEmail(user.getEmail());
            actor.setMobile(user.getMobile());
            actor.setWeixin(user.getWeixin());
            actor.setClientId(user.getClientId());
            actor.setClientToken(user.getClientToken());
            actors.add(actor);
        }
        return actors;
    }

    public static void sendMsgnew(String notifyType, List<IUser> recievers, String subject, String content) throws Exception {
        NoticeMessageType[] messageTypes = MessageUtil.parseNotifyType(notifyType);
        List<JmsActor> recieverAccounts = MessageUtil.parseJmsActor(recievers);
        IUser sender = ContextUtil.getCurrentUser();
        Notice notice = new Notice();
        notice.setUseTemplate(true);
        notice.setSubject(subject);
        notice.setContent(content);
        notice.setMessageTypes(messageTypes);
        notice.setSender(sender.getAccount());
        notice.setReceiver(recieverAccounts);
        JmsProducer jmsProducer = (JmsProducer)AppUtil.getBean(JmsProducer.class);
        jmsProducer.sendToQueue((Object)notice);
    }
}

