/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.listener;

import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.jms.JmsProducer;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.bpm.api.event.AutoTestEvent;
import com.artfess.bpm.persistence.model.AutoTestModel;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.client.ClientProtocolException;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AutoTestEventListener
implements ApplicationListener<AutoTestEvent>,
Ordered {
    public int getOrder() {
        return 0;
    }

    public void onApplicationEvent(AutoTestEvent event) {
        AutoTestModel model = (AutoTestModel)event.getSource();
        try {
            this.doNext(model);
        }
        catch (Exception e) {
            throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void doNext(AutoTestModel model) throws ClientProtocolException, IOException {
        ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
        jsonObject.put("account", model.getRandomAccount());
        jsonObject.put("actionName", "agree");
        jsonObject.put("taskId", model.getTaskId());
        jsonObject.put("tenantId", model.getTenantId());
        JmsProducer jmsProducer = (JmsProducer)AppUtil.getBean(JmsProducer.class);
        jmsProducer.sendToQueue((Object)model, "bpmTestCase");
    }
}

