/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.model.var;

import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.bpm.api.model.process.def.BpmVariableDef;

public class DefaultBpmVariableDef
implements BpmVariableDef {
    private static final long serialVersionUID = 278555366495215660L;
    private String nodeId = "";
    private String name = "";
    private String varKey = "";
    private String dataType = "";
    private Object defaultVal = "";
    private boolean isRequired = false;
    private String description = "";

    public DefaultBpmVariableDef() {
    }

    public static Object getValue(String dataType, String value) {
        if ("double".equals(dataType)) {
            if (value == null || StringUtil.isEmpty((String)value)) {
                return new Double(0.0);
            }
            return new Double(value);
        }
        if ("float".equals(dataType)) {
            if (value == null || StringUtil.isEmpty((String)value)) {
                return new Float(0.0f);
            }
            return new Float(value);
        }
        if ("int".equals(dataType)) {
            if (value == null || StringUtil.isEmpty((String)value)) {
                return 0;
            }
            return new Integer(value);
        }
        if ("date".equals(dataType)) {
            return DateFormatUtil.parse((String)value, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"});
        }
        return value;
    }

    public DefaultBpmVariableDef(String name, String varKey, String dataType, String defaultVal, boolean isRequired, String description) {
        this.name = name;
        this.varKey = varKey;
        this.dataType = dataType;
        this.defaultVal = DefaultBpmVariableDef.getValue(dataType, defaultVal);
        this.isRequired = isRequired;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getVarKey() {
        return this.varKey;
    }

    @Override
    public void setVarKey(String varKey) {
        this.varKey = varKey;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Override
    public Object getDefaultVal() {
        return this.defaultVal;
    }

    @Override
    public void setDefaultVal(Object defaultVal) {
        this.defaultVal = defaultVal;
    }

    public void setDefaultVal(String defaulVal2) {
        this.defaultVal = DefaultBpmVariableDef.getValue(this.dataType, defaulVal2);
    }

    @Override
    public boolean getIsRequired() {
        return this.isRequired;
    }

    @Override
    public void setIsRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Override
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }
}

