/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.form.dao.FormRemindDataDao;
import com.artfess.form.manager.FormRemindDataManager;
import com.artfess.form.model.FormRemindData;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.service.IUserGroupService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class FormRemindDataManagerImpl
extends BaseManagerImpl<FormRemindDataDao, FormRemindData>
implements FormRemindDataManager {
    @Resource
    IUserGroupService defaultUserGroupService;

    @Override
    public void deleteFormRemindDataByBoDataId(QueryWrapper queryWrapper) throws IOException {
        ((FormRemindDataDao)this.baseMapper).delete((Wrapper)queryWrapper);
    }

    @Override
    public List<FormRemindData> getFormRemindDataByUser() {
        Map<String, String> map = this.convertGroupList(ContextUtil.getCurrentUserId());
        List<FormRemindData> formRemindDataByUser = ((FormRemindDataDao)this.baseMapper).getFormRemindDataByUser(map);
        return formRemindDataByUser;
    }

    private Map<String, String> convertGroupList(String userId) {
        List list = this.defaultUserGroupService.getGroupsByUserIdOrAccount(userId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("user", userId);
        if (BeanUtils.isEmpty((Object)list)) {
            return map;
        }
        for (IGroup group : list) {
            String type = group.getGroupType();
            if (map.containsKey(type)) {
                String groupId = (String)map.get(type);
                groupId = groupId + ",'" + group.getGroupId() + "'";
                map.put(type, groupId);
                continue;
            }
            map.put(type, "'" + group.getGroupId() + "'");
        }
        return map;
    }
}

