/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.form.model.CustomDialog;
import com.artfess.form.model.CustomQuery;
import com.artfess.form.persistence.manager.CustomDialogManager;
import com.artfess.form.persistence.manager.CustomQueryManager;
import com.artfess.form.vo.CustomQueryControllerVo;
import com.artfess.table.meta.impl.BaseTableMeta;
import com.artfess.table.model.Column;
import com.artfess.table.model.Table;
import com.artfess.table.operator.IViewOperator;
import com.artfess.table.util.MetaDataUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/form/customQuery/v1"})
@Api(tags={"\u5173\u8054\u6570\u636e"})
@ApiGroup(group={"group_form"})
public class CustomQueryController
extends BaseController<CustomQueryManager, CustomQuery> {
    @Resource
    CustomDialogManager customDialogManager;
    @Resource
    DatabaseContext databaseContext;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)", httpMethod="POST", notes="\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)")
    public PageList listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody Optional<QueryFilter> queryFilter) throws Exception {
        QueryFilter filter = queryFilter.orElse(QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE)));
        if (BeanUtils.isEmpty((Object)filter.getPageBean())) {
            filter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        }
        return ((CustomQueryManager)this.baseService).query(filter);
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u522b\u540d\u83b7\u53d6\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f", httpMethod="POST", notes="\u901a\u8fc7\u522b\u540d\u83b7\u53d6\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f")
    public CustomQuery getByAlias(@ApiParam(name="alias", value="\u522b\u540d") @RequestBody String alias) {
        return ((CustomQueryManager)this.baseService).getByAlias(alias);
    }

    @RequestMapping(value={"customQueryGet"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f", httpMethod="POST", notes="\u83b7\u53d6\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f")
    public CustomQuery get(@ApiParam(name="id", value="\u4e3b\u952e") @RequestBody String id) throws Exception {
        return (CustomQuery)((CustomQueryManager)this.baseService).get((Serializable)((Object)id));
    }

    @RequestMapping(value={"saveDialogByQuery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5173\u8054\u67e5\u8be2\u6dfb\u52a0\u4e3a\u5bf9\u8bdd\u6846", httpMethod="POST", notes="\u5173\u8054\u67e5\u8be2\u6dfb\u52a0\u4e3a\u5bf9\u8bdd\u6846")
    public CommonResult saveDialogByQuery(@ApiParam(name="json", value="\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606fjson\u5bf9\u8c61") @RequestBody String json) throws Exception {
        String resultMsg;
        CustomDialog customDialog = null;
        if (!StringUtil.isEmpty((String)json)) {
            ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)json);
            String displayfield = node.get("resultfield") + "";
            String conditionfield = node.get("conditionfield") + "";
            String resultfield = node.get("resultfield") + "";
            String sortfield = node.get("sortfield") + "";
            node.remove("displayfield");
            node.remove("conditionfield");
            node.remove("resultfield");
            node.remove("sortfield");
            customDialog = (CustomDialog)((Object)JsonUtil.toBean((JsonNode)node, CustomDialog.class));
            customDialog.setDisplayfield(displayfield);
            customDialog.setConditionfield(conditionfield);
            customDialog.setResultfield(resultfield);
            customDialog.setSortfield(sortfield);
            customDialog.setStyle(new Short("0"));
            customDialog.setSelectNum(1);
        }
        CustomDialog entity = new CustomDialog();
        if (StringUtil.isNotEmpty((String)customDialog.getAlias())) {
            entity = this.customDialogManager.getByAlias(customDialog.getAlias());
        }
        if (BeanUtils.isEmpty((Object)((Object)entity))) {
            if (this.customDialogManager.getByAlias(customDialog.getAlias()) != null) {
                return new CommonResult(false, customDialog.getAlias() + "\uff0c\u5df2\u5b58\u5728", null);
            }
            customDialog.setId(UniqueIdUtil.getSuid());
            customDialog.setCreateTime(LocalDateTime.now());
            customDialog.setUpdateTime(DateUtil.getCurrentDate());
            this.customDialogManager.create((Model)customDialog);
            resultMsg = "\u6dfb\u52a0\u6210\u529f";
        } else {
            customDialog.setId(entity.getId());
            customDialog.setUpdateTime(LocalDateTime.now());
            this.customDialogManager.update((Model)customDialog);
            resultMsg = "\u66f4\u65b0\u6210\u529f";
        }
        return new CommonResult(true, resultMsg, null);
    }

    @RequestMapping(value={"saveQueryByDialog"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bf9\u8bdd\u6846\u6dfb\u52a0\u4e3a\u5173\u8054\u67e5\u8be2", httpMethod="POST", notes="\u5bf9\u8bdd\u6846\u6dfb\u52a0\u4e3a\u5173\u8054\u67e5\u8be2")
    public CommonResult saveQueryByDialog(@ApiParam(name="json", value="\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606fjson\u5bf9\u8c61") @RequestBody String json) throws Exception {
        CustomQuery customQuery = this.queryByDialog(json);
        String resultMsg = null;
        CustomQuery entity = new CustomQuery();
        if (StringUtil.isNotEmpty((String)customQuery.getAlias())) {
            entity = ((CustomQueryManager)this.baseService).getByAlias(customQuery.getAlias());
        }
        if (BeanUtils.isEmpty((Object)((Object)entity))) {
            if (((CustomQueryManager)this.baseService).getByAlias(customQuery.getAlias()) != null) {
                return new CommonResult(false, customQuery.getAlias() + "\uff0c\u5df2\u5b58\u5728", null);
            }
            customQuery.setId(UniqueIdUtil.getSuid());
            ((CustomQueryManager)this.baseService).create((Model)customQuery);
            resultMsg = "\u6dfb\u52a0\u6210\u529f";
        } else {
            customQuery.setId(entity.getId());
            ((CustomQueryManager)this.baseService).update((Model)customQuery);
            resultMsg = "\u66f4\u65b0\u6210\u529f";
        }
        return new CommonResult(true, resultMsg, null);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f")
    public CommonResult save(@ApiParam(name="json", value="\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606fjson\u5bf9\u8c61") @RequestBody String json) throws Exception {
        CustomQuery customQuery = this.getCustomQuery(json);
        String resultMsg = null;
        if (StringUtil.isEmpty((String)customQuery.getId())) {
            if (((CustomQueryManager)this.baseService).getByAlias(customQuery.getAlias()) != null) {
                return new CommonResult(false, "\u522b\u540d" + customQuery.getAlias() + "\uff0c\u5df2\u5b58\u5728", null);
            }
            customQuery.setId(UniqueIdUtil.getSuid());
            ((CustomQueryManager)this.baseService).create((Model)customQuery);
            resultMsg = "\u6dfb\u52a0\u6210\u529f";
        } else {
            ((CustomQueryManager)this.baseService).update((Model)customQuery);
            resultMsg = "\u66f4\u65b0\u6210\u529f";
        }
        return new CommonResult(true, resultMsg, null);
    }

    @RequestMapping(value={"removes"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f")
    public CommonResult removes(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String ids) throws Exception {
        String[] aryIds = StringUtil.getStringAryByStr((String)ids);
        ((CustomQueryManager)this.baseService).removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f\u6210\u529f", null);
    }

    @RequestMapping(value={"getByDsObjectName"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u6216\u89c6\u56fe\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u8868\u6216\u89c6\u56fe\u5217\u8868")
    public ArrayNode getByDsObjectName(@ApiParam(name="vo", value="") @RequestBody CustomQueryControllerVo vo) throws Exception {
        if (SQLUtil.containsSqlInjection((String)vo.getObjName())) {
            throw new BaseException(ResponseErrorEnums.BAD_REQUEST);
        }
        return ((CustomQueryManager)this.baseService).getTableOrViewByDsName(vo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"getTable"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u8868\u5bf9\u8c61", httpMethod="POST", notes="\u83b7\u5f97\u8868\u5bf9\u8c61")
    public ObjectNode getTable(@ApiParam(name="vo", value="") @RequestBody CustomQueryControllerVo vo, @ApiParam(name="flag", value="\u8868\u4e3b\u952e\u7c7b\u578b\u957f\u5ea6\u662f\u5426\u5141\u8bb8\u5c0f\u4e8e19") @RequestParam Optional<Boolean> flag) throws Exception {
        ObjectNode result = JsonUtil.getMapper().createObjectNode();
        try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(vo.getDsalias());){
            Table table = null;
            if (vo.getIsTable().equals("1")) {
                BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)dResult.getDbType());
                table = baseTableMeta.getTableByName(vo.getObjName());
            } else {
                IViewOperator iViewOperator = MetaDataUtil.getIViewOperatorAfterSetDT((String)dResult.getDbType());
                table = iViewOperator.getModelByViewName(vo.getObjName());
            }
            boolean isFlag = flag.orElse(true);
            if (BeanUtils.isNotEmpty((Object)table.getColumnList())) {
                for (Column column : table.getColumnList()) {
                    if (!column.getIsPk()) continue;
                    if (isFlag || !"int".equals(column.getColumnType()) && !"number".equals(column.getColumnType()) || column.getIntLen() >= 19) break;
                    throw new BaseException("\u5f53\u524d\u8868\u4e3b\u952e\u7c7b\u578b\u4e3a\u6570\u5b57\uff0c\u4e14\u957f\u5ea6\u5c0f\u4e8e19\uff0c\u65e0\u6cd5\u5e94\u7528\u7cfb\u7edf\u4e3b\u952e\u751f\u6210\u89c4\u5219\uff0c\u6dfb\u52a0\u5931\u8d25\uff01 ");
                }
            }
            result.set("table", JsonUtil.toJsonNode((Object)table));
            ObjectNode objectNode = result;
            return objectNode;
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"doQuery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="", httpMethod="POST", notes="")
    public PageList doQuery(@ApiParam(name="alias", value="\u522b\u540d") @RequestParam Optional<String> alias, @ApiParam(name="queryData", value="") @RequestBody Optional<String> queryData, @ApiParam(name="page", value="") @RequestParam Optional<Integer> page) throws Exception {
        CustomQuery customQuery = ((CustomQueryManager)this.baseService).getByAlias(alias.orElse(null));
        if (customQuery == null) {
            return null;
        }
        try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(customQuery.getDsalias());){
            PageList data;
            PageList pageList = data = ((CustomQueryManager)this.baseService).getData(customQuery, queryData.orElse(null), dResult.getDbType(), (Integer)page.orElse(null), customQuery.getPageSize());
            return pageList;
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"doQueryBase64"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="", httpMethod="GET", notes="")
    public PageList doQueryBase64(@ApiParam(name="alias", value="\u522b\u540d") @RequestParam String alias, @ApiParam(name="queryData", value="") @RequestParam String queryData, @ApiParam(name="page", value="") @RequestParam Integer page) throws Exception {
        CustomQuery customQuery = ((CustomQueryManager)this.baseService).getByAlias(alias);
        if (customQuery == null) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)queryData)) {
            queryData = Base64.getFromBase64((String)queryData);
            queryData = Base64.getFromBase64((String)queryData);
        }
        try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(customQuery.getDsalias());){
            PageList data;
            PageList pageList = data = ((CustomQueryManager)this.baseService).getData(customQuery, queryData, dResult.getDbType(), page, customQuery.getPageSize());
            return pageList;
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"getAll"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u6240\u6709\u7684\u8868\u5bf9\u8c61", httpMethod="GET", notes="\u53d6\u5f97\u6240\u6709\u7684\u8868\u5bf9\u8c61")
    public List<CustomQuery> getAll() throws Exception {
        List customQuerys = ((CustomQueryManager)this.baseService).list();
        return customQuerys;
    }

    @RequestMapping(value={"getQueryPage"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="", httpMethod="GET", notes="")
    public PageList getQueryPage(@ApiParam(name="alias", value="\u522b\u540d") @RequestParam String alias) throws Exception {
        PageList pageList = new PageList();
        CustomQuery customQuery = ((CustomQueryManager)this.baseService).getByAlias(alias);
        if (customQuery == null) {
            return null;
        }
        try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(customQuery.getDsalias());){
            customQuery.setNeedPage(0);
            pageList = ((CustomQueryManager)this.baseService).getData(customQuery, null, dResult.getDbType(), 1, 20);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        return pageList;
    }

    private CustomQuery queryByDialog(String json) throws Exception {
        CustomQuery customQuery = null;
        ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)json);
        String conditionfield = node.get("conditionfield").toString();
        String resultfield = node.get("displayfield").toString();
        String sortfield = node.get("sortfield").toString();
        String header = JsonUtil.getString((JsonNode)node, (String)"header");
        node.remove("conditionfield");
        node.remove("resultfield");
        node.remove("sortfield");
        customQuery = (CustomQuery)((Object)JsonUtil.toBean((JsonNode)node, CustomQuery.class));
        customQuery.setConditionfield(conditionfield);
        customQuery.setResultfield(resultfield);
        customQuery.setSortfield(sortfield);
        if (StringUtil.isNotEmpty((String)header)) {
            customQuery.setHeader(header);
        }
        customQuery.setPageSize(10);
        return customQuery;
    }

    private CustomQuery getCustomQuery(String json) throws Exception {
        CustomQuery customQuery = null;
        ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)json);
        String conditionfield = node.get("conditionfield").toString();
        String resultfield = node.get("resultfield").toString();
        String sortfield = node.get("sortfield").toString();
        String header = JsonUtil.getString((JsonNode)node, (String)"header");
        node.remove("conditionfield");
        node.remove("resultfield");
        node.remove("sortfield");
        customQuery = (CustomQuery)((Object)JsonUtil.toBean((JsonNode)node, CustomQuery.class));
        customQuery.setConditionfield(conditionfield);
        customQuery.setResultfield(resultfield);
        customQuery.setSortfield(sortfield);
        if (StringUtil.isNotEmpty((String)header)) {
            customQuery.setHeader(header);
        }
        return customQuery;
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        String[] idList = ids.split(",");
        String fileName = "customQuery_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        String json = ((CustomQueryManager)this.baseService).export(idList);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"customQuery.json", (String)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u81ea\u5b9a\u4e49\u67e5\u8be2", httpMethod="POST", notes="\u5bfc\u5165\u81ea\u5b9a\u4e49\u67e5\u8be2")
    public CommonResult<String> importCustom(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            ((CustomQueryManager)this.baseService).importFile(unZipFilePath);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
        }
    }
}

