/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bo.instance.BoDataHandler;
import com.artfess.bo.model.BoData;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.persistence.manager.BoAttributeManager;
import com.artfess.bo.persistence.manager.BoDefManager;
import com.artfess.bo.persistence.manager.BoEntManager;
import com.artfess.form.model.FormMeta;
import com.artfess.form.persistence.manager.FormMetaManager;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bo/def/v1/"})
@Api(tags={"\u4e1a\u52a1\u5bf9\u8c61\u5b9a\u4e49"})
@ApiGroup(group={"group_form"})
public class BoDefController
extends BaseController<BoDefManager, BoDef> {
    @Resource
    BoEntManager boEntManager;
    @Resource
    BoDataHandler boDataHandler;
    @Resource
    FormMetaManager bpmFormDefManager;
    @Resource
    BoAttributeManager boAttributeManager;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6bo\u5b9a\u4e49\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6bo\u5b9a\u4e49\u5217\u8868")
    public PageList<BoDef> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BoDef> queryFilter) throws Exception {
        if (BeanUtils.isEmpty((Object)queryFilter.getSorter())) {
            queryFilter.getSorter().add(new FieldSort("createTime", Direction.DESC));
        }
        return super.query(queryFilter);
    }

    @RequestMapping(value={"detail"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6bo\u5b9a\u4e49\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6bo\u5b9a\u4e49\u8be6\u60c5")
    public BoDef detail(@ApiParam(name="alias", value="bo\u5b9a\u4e49\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        return ((BoDefManager)this.baseService).getPureByAlias(alias);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6bo\u5b9a\u4e49\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6bo\u5b9a\u4e49\u8be6\u60c5")
    public ObjectNode getJson(@ApiParam(name="id", value="id", required=true) @RequestParam String id) throws Exception {
        return ((BoDefManager)this.baseService).getBoDefDetails(id);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0bo\u5b9a\u4e49", httpMethod="POST", notes="\u6dfb\u52a0bo\u5b9a\u4e49")
    public CommonResult<String> save(@ApiParam(name="json", value="bo\u5b9a\u4e49\u7684json\u6570\u636e", required=true) @RequestBody String json) throws Exception {
        ((BoDefManager)this.baseService).save(json);
        return new CommonResult("\u6dfb\u52a0\u6210\u529f");
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664bo\u5b9a\u4e49", httpMethod="DELETE", notes="\u5220\u9664bo\u5b9a\u4e49")
    public CommonResult<Integer> remove(@ApiParam(name="alias", value="bo\u5b9a\u4e49\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        int removeItems = ((BoDefManager)this.baseService).removeByAlias(alias);
        if (removeItems > 0) {
            return new CommonResult(true, "\u5220\u9664\u6210\u529f", (Object)removeItems);
        }
        return new CommonResult(false, "\u5220\u9664\u5931\u8d25", (Object)removeItems);
    }

    @RequestMapping(value={"removes"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664bo\u5b9a\u4e49", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664bo\u5b9a\u4e49")
    public CommonResult<String> batchRemove(String ... ids) throws Exception {
        List<String> errList = this.removeBoDefDetails(ids);
        if (errList.size() == 0) {
            return new CommonResult(true, "\u5220\u9664\u6210\u529f");
        }
        return new CommonResult(false, "\u5220\u9664\u5931\u8d25" + errList.size() + "\u4e2a," + StringUtil.join(errList, (String)","));
    }

    @RequestMapping(value={"getBoJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636ebo\u522b\u540d\u8fd4\u56debo\u5bf9\u5e94\u7684JSON\u6570\u636e\u7ed3\u6784", httpMethod="GET", notes="\u6839\u636ebo\u5b9a\u4e49\u8fd4\u56debo\u5bf9\u5e94\u7684JSON\u6570\u636e\u7ed3\u6784")
    public JsonNode getBoJson(@ApiParam(name="alias", value="bo\u5b9a\u4e49\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        BoData boData = this.boDataHandler.getByBoDefCode(alias);
        return JsonUtil.toJsonNode((String)boData.toString());
    }

    @RequestMapping(value={"deploy"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u5e03", httpMethod="GET", notes="\u53d1\u5e03")
    public CommonResult deploy(@ApiParam(name="id", value="id", required=true) @RequestParam String id) throws Exception {
        BoDef boDef = ((BoDefManager)this.baseService).getByDefId(id);
        boDef.setDeployed(true);
        ((BoDefManager)this.baseService).update(boDef);
        return new CommonResult(boDef.getDescription() + "\u53d1\u5e03\u6210\u529f");
    }

    @RequestMapping(value={"setStatus"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u72b6\u6001", httpMethod="GET", notes="\u4fee\u6539\u72b6\u6001")
    public CommonResult setStatus(@ApiParam(name="id", value="id", required=true) @RequestParam String id, @ApiParam(name="status", value="\u72b6\u6001") @RequestParam String status) throws Exception {
        if (status == null || "".equals(status)) {
            status = "normal";
        }
        BoDef boDef = ((BoDefManager)this.baseService).getByDefId(id);
        boDef.setStatus(status);
        ((BoDefManager)this.baseService).update(boDef);
        return new CommonResult(boDef.getDescription() + "\u66f4\u6539\u72b6\u6001\u6210\u529f");
    }

    @RequestMapping(value={"getBOTree"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6BO\u6811\u5f62\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6BO\u6811\u5f62\u6570\u636e")
    public ObjectNode getBOTree(@ApiParam(name="ids", value="ids", required=true) @RequestBody String ids) throws Exception {
        return ((BoDefManager)this.baseService).getBoTreeData(ids);
    }

    @RequestMapping(value={"getAllBos"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709bo\u5b9e\u4f53\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709bo\u5b9e\u4f53\u5217\u8868")
    public List<BoEnt> getAllBos() throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("is_create_table_", (Object)1, QueryOP.EQUAL);
        PageList pageList = this.boEntManager.query(queryFilter);
        return pageList.getRows();
    }

    @RequestMapping(value={"getBoEntById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709bo\u5b9e\u4f53\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709bo\u5b9e\u4f53\u5217\u8868")
    public BoEnt getBoEntById(@ApiParam(name="id", value="id", required=true) @RequestParam String id) throws Exception {
        return this.boEntManager.getById(id);
    }

    @RequestMapping(value={"getSupportDb"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709bo\u5b9e\u4f53\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709bo\u5b9e\u4f53\u5217\u8868")
    public boolean getSupportDb(@ApiParam(name="alias", value="bo\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        return ((BoDefManager)this.baseService).getPureByAlias(alias).isSupportDb();
    }

    @RequestMapping(value={"getObject"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6bodef", httpMethod="GET", notes="\u83b7\u53d6bodef")
    public BoDef getObject(@ApiParam(name="id", value="bodef\u4e3b\u952e", required=false) @RequestParam(required=false) String id, @ApiParam(name="key", value="bodef key", required=false) @RequestParam(required=false) String key) throws Exception {
        if (StringUtil.isNotEmpty((String)id)) {
            BoDef boDef = (BoDef)((BoDefManager)this.baseService).get((Serializable)((Object)id));
            return boDef;
        }
        if (StringUtil.isNotEmpty((String)key)) {
            BoDef boDef = ((BoDefManager)this.baseService).getByAlias(key);
            return boDef;
        }
        return null;
    }

    @RequestMapping(value={"updateCategory"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539bodef\u5206\u7c7b", httpMethod="GET", notes="\u4fee\u6539bodef\u5206\u7c7b")
    public CommonResult<String> updateCategory(@ApiParam(name="ids", value="ids", required=true) @RequestParam(required=true) String[] ids, @ApiParam(name="categoryId", value="categoryId", required=true) @RequestParam(required=true) String categoryId, @ApiParam(value="categoryName", name="categoryName", required=true) @RequestParam(required=true) String categoryName) throws IOException {
        for (int i = 0; i < ids.length; ++i) {
            BoDef boDef = (BoDef)((BoDefManager)this.baseService).get((Serializable)((Object)ids[i]));
            boDef.setCategoryId(categoryId);
            boDef.setCategoryName(categoryName);
            ((BoDefManager)this.baseService).updateCategory(boDef);
        }
        return new CommonResult(true, "\u8bbe\u7f6e\u5206\u7c7b\u6210\u529f");
    }

    @RequestMapping(value={"removeAttr"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539boAttribute\u5206\u7c7b", httpMethod="POST", notes="\u4fee\u6539bodef\u5206\u7c7b")
    public CommonResult<String> removeAttr(@ApiParam(name="alias", value="alias", required=true) @RequestParam(required=true) String alias, @ApiParam(name="json", value="json", required=true) @RequestBody(required=true) String json) throws Exception {
        this.boAttributeManager.updateAttrStatus(json, alias);
        return new CommonResult(true, "\u5b57\u6bb5\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"createTableForm"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u521b\u5efa\u8868\u5355", httpMethod="POST", notes="\u4fee\u6539bodef\u5206\u7c7b")
    public CommonResult<String> createTableForm(@ApiParam(name="json", value="json", required=true) @RequestBody(required=true) String json) throws Exception {
        CommonResult<String> vresult = this.validateBoAttr(json);
        if (!vresult.getState().booleanValue()) {
            return vresult;
        }
        String defId = ((BoDefManager)this.baseService).saveFormData(json);
        return new CommonResult(true, defId);
    }

    @RequestMapping(value={"getBindData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ed1\u5b9a\u6570\u636e", httpMethod="GET", notes="\u4fee\u6539bodef\u5206\u7c7b")
    public String getBindData(@ApiParam(name="id", value="id", required=true) @RequestParam(required=true) String id, @ApiParam(name="alias", value="alias", required=true) @RequestParam(required=true) String alias) throws IOException {
        Map result = ((BoDefManager)this.baseService).getBindData(id, alias);
        String json = JsonUtil.toJson((Object)result);
        return json;
    }

    @RequestMapping(value={"deleteAttr"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664attr\u6570\u636e", httpMethod="POST", notes="\u5220\u9664attr\u6570\u636e")
    public CommonResult<String> deleteAttr(@ApiParam(name="id", value="id", required=true) @RequestParam(required=true) String id) throws IOException {
        this.boAttributeManager.remove((Serializable)((Object)id));
        return new CommonResult(true, "\u5b57\u6bb5\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"recovery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8fd8\u539f\u5220\u9664\u6570\u636e", httpMethod="POST", notes="\u8fd8\u539f\u5220\u9664\u6570\u636e")
    public CommonResult<String> recovery(@ApiParam(name="alias", value="alias", required=true) @RequestParam(required=true) String alias, @ApiParam(name="json", value="json", required=true) @RequestBody String json) throws Exception {
        this.boAttributeManager.recovery(json, alias);
        return new CommonResult(true, "\u5b57\u6bb5\u8fd8\u539f\u6210\u529f");
    }

    @RequestMapping(value={"getHideAttr"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u9690\u85cf\u5b57\u6bb5", httpMethod="GET", notes="\u83b7\u53d6\u9690\u85cf\u5b57\u6bb5")
    public List getHideAttr(@ApiParam(name="tableName", value="\u8868\u540d") @RequestParam String tableName) throws Exception {
        return ((BoDefManager)this.baseService).getHideAttr(tableName);
    }

    @RequestMapping(value={"getSubEntInfo"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6BO\u5efa\u6a21\u4e2d\u662f\u5426\u5b58\u5728\u5b50\u8868\u3001\u5b59\u8868", httpMethod="GET", notes="\u83b7\u53d6BO\u5efa\u6a21\u4e2d\u662f\u5426\u5b58\u5728\u5b50\u8868\u3001\u5b59\u8868")
    public ObjectNode getSubEntInfo(@ApiParam(name="ids", value="bo\u5b9a\u4e49id\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u5272", required=true) @RequestParam String ids, @ApiParam(name="isMobile", value="\u662f\u5426\u79fb\u52a8\u7aef", required=false) @RequestParam Optional<Boolean> isMobile) throws Exception {
        ObjectNode infoNode = JsonUtil.getMapper().createObjectNode();
        boolean hasSub = false;
        boolean hasSun = false;
        ArrayNode entArray = JsonUtil.getMapper().createArrayNode();
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] idArray;
            for (String id : idArray = ids.split(",")) {
                BoDef def = ((BoDefManager)this.baseService).getByDefId(id);
                BoEnt mainEnt = def.getBoEnt();
                entArray.add((JsonNode)this.getEntNode(mainEnt.getId(), mainEnt.getName(), mainEnt.getDesc(), "main", isMobile.orElse(false)));
                List subEnts = mainEnt.getChildEntList();
                if (!BeanUtils.isNotEmpty((Object)subEnts)) continue;
                hasSub = true;
                for (BoEnt boEnt : subEnts) {
                    entArray.add((JsonNode)this.getEntNode(boEnt.getId(), boEnt.getName(), boEnt.getDesc(), "sub", isMobile.orElse(false)));
                    List sunEnts = boEnt.getChildEntList();
                    if (!BeanUtils.isNotEmpty((Object)sunEnts)) continue;
                    hasSun = true;
                    for (BoEnt sunEnt : sunEnts) {
                        entArray.add((JsonNode)this.getEntNode(sunEnt.getId(), sunEnt.getName(), sunEnt.getDesc(), "sun", isMobile.orElse(false)));
                    }
                }
            }
        }
        infoNode.put("hasSub", hasSub);
        infoNode.put("hasSun", hasSun);
        infoNode.set("entList", (JsonNode)entArray);
        return infoNode;
    }

    private ObjectNode getEntNode(String id, String alias, String name, String type, boolean isMobile) {
        ObjectNode entNode = JsonUtil.getMapper().createObjectNode();
        entNode.put("id", id);
        entNode.put("alias", alias);
        entNode.put("name", name);
        entNode.put("type", type);
        entNode.put("template", "main".equals(type) ? "grid" : "table");
        entNode.put("column", isMobile ? 1 : 2);
        return entNode;
    }

    @GetMapping(value={"reloadByEntId"})
    @ResponseBody
    public ObjectNode reloadByEntId(@RequestParam(value="entId", required=true) String entId, @RequestParam(value="alias", required=true) String alias) throws Exception {
        return this.boEntManager.reloadByEntId(entId, alias);
    }

    private List<String> removeBoDefDetails(String ... ids) {
        ArrayList<String> delIdList = new ArrayList<String>();
        ArrayList<String> errList = new ArrayList<String>();
        for (String id : ids) {
            List<FormMeta> list = this.bpmFormDefManager.getByBODefId(id);
            if (list.size() == 0) {
                delIdList.add(id);
                continue;
            }
            ArrayList<String> formNameList = new ArrayList<String>();
            for (FormMeta bpmFormDef : list) {
                formNameList.add(bpmFormDef.getName());
            }
            BoDef bo = (BoDef)((BoDefManager)this.baseService).get((Serializable)((Object)id));
            String msg = "\u3010" + bo.getDescription() + "\u3011\u5df2\u7ed1\u5b9a\u8868\u5355\uff1a" + StringUtil.join(formNameList, (String)",");
            errList.add(msg);
        }
        String[] delIds = delIdList.toArray(new String[delIdList.size()]);
        if (errList.size() == 0) {
            ((BoDefManager)this.baseService).removeByIds(delIds);
            return errList;
        }
        return errList;
    }

    @RequestMapping(value={"reload"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5237\u65b0\u5143\u6570\u636e", httpMethod="GET", notes="\u5237\u65b0\u5143\u6570\u636e")
    public CommonResult<String> reload(@ApiParam(name="id", value="id", required=true) @RequestParam(required=true) String id, @RequestParam(value="alias", required=true) String alias) throws IOException {
        try {
            this.boEntManager.reloadByEntId(id, alias);
            return new CommonResult(true, "\u5237\u65b0\u5143\u6570\u636e\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u5237\u65b0\u5143\u6570\u636e\u5931\u8d25");
        }
    }

    @RequestMapping(value={"deleteExternalEnt"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u5916\u90e8\u8868\u7684\u5b50\u5b9e\u4f53\u4ee5\u53ca\u5b59\u5b9e\u4f53", httpMethod="POST", notes="\u5220\u9664\u5916\u90e8\u8868\u7684\u5b50\u5b9e\u4f53\u4ee5\u53ca\u5b59\u5b9e\u4f53")
    public CommonResult<String> deleteExternalEnt(@ApiParam(name="\u8981\u88ab\u5220\u9664ent\u6570\u636e", value="ent", required=true) @RequestBody Map<String, String> ent) throws Exception {
        try {
            String entjson = ent.get("entjson");
            ((BoDefManager)this.baseService).deleteExternalEnt(entjson);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25");
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f!");
    }

    private CommonResult<String> validateBoAttr(String json) {
        try {
            JsonNode jsonObj = JsonUtil.toJsonNode((String)json);
            if (jsonObj.has("ents")) {
                ArrayNode entArray = (ArrayNode)jsonObj.get("ents");
                for (JsonNode entNode : entArray) {
                    ArrayNode childrens;
                    if (entNode.has("attributeList")) {
                        String type = "main".equals(entNode.get("relation").asText()) ? "\u4e3b" : "\u5b50";
                        ArrayNode attrArray = (ArrayNode)entNode.get("attributeList");
                        HashSet<String> attrSet = new HashSet<String>();
                        for (JsonNode attrNode : attrArray) {
                            String name = attrNode.get("name").asText();
                            if (attrSet.contains(name)) {
                                String entName = entNode.get("desc").asText();
                                return new CommonResult(false, type + "\u5b9e\u4f53\u3010" + entName + "\uff08" + entNode.get("name").asText() + "\uff09\u3011\u4e2d\u7684\u5b57\u6bb5\u540d\uff1a" + name + " \u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002");
                            }
                            attrSet.add(name);
                        }
                    }
                    if (!entNode.has("children") || !BeanUtils.isNotEmpty((Object)(childrens = (ArrayNode)entNode.get("children")))) continue;
                    for (JsonNode sunEntNode : childrens) {
                        if (!sunEntNode.has("attributeList")) continue;
                        ArrayNode attrArray = (ArrayNode)sunEntNode.get("attributeList");
                        HashSet<String> attrSet = new HashSet<String>();
                        for (JsonNode attrNode : attrArray) {
                            String name = attrNode.get("name").asText();
                            if (attrSet.contains(name)) {
                                String entName = sunEntNode.get("desc").asText();
                                return new CommonResult(false, "\u5b59\u5b9e\u4f53\u3010" + entName + "\uff08" + sunEntNode.get("name").asText() + "\uff09\u3011\u4e2d\u7684\u5b57\u6bb5\u540d\uff1a" + name + " \u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002");
                            }
                            attrSet.add(name);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            return new CommonResult(false, "\u4fdd\u5b58\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a" + e.getMessage());
        }
        return new CommonResult(true, "\u6821\u9a8c\u901a\u8fc7");
    }

    @RequestMapping(value={"getPkTypeByDefAlias"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636ebo\u522b\u540d\u83b7\u53d6\u4e3b\u952e\u4fdd\u5b58\u65b9\u5f0f", httpMethod="GET", notes="\u6839\u636ebo\u522b\u540d\u83b7\u53d6\u4e3b\u952e\u4fdd\u5b58\u65b9\u5f0f")
    public String getPkTypeByDefAlias(@ApiParam(name="alias", value="alias") @RequestParam String alias) {
        BoDef def = ((BoDefManager)this.baseService).getByAlias(alias);
        if (BeanUtils.isEmpty((Object)def) || BeanUtils.isEmpty((Object)def.getBoEnt())) {
            return null;
        }
        return def.getBoEnt().getPkType();
    }
}

