/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.cache.aspect;

import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.cache.annotation.CachePut;
import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.cache.annotation.FirstCache;
import com.artfess.base.cache.annotation.SecondaryCache;
import com.artfess.base.cache.expression.CacheOperationExpressionEvaluator;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.base.cache.setting.FirstCacheSetting;
import com.artfess.base.cache.setting.SecondaryCacheSetting;
import com.artfess.base.cache.support.CacheOperationInvoker;
import com.artfess.base.cache.support.KeyGenerator;
import com.artfess.base.cache.support.SimpleKeyGenerator;
import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.context.BaseContext;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.SerializationException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class CacheAspect {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CACHE_KEY_ERROR_MESSAGE = "\u7f13\u5b58Key %s \u4e0d\u80fd\u4e3aNULL";
    private static final String CACHE_NAME_ERROR_MESSAGE = "\u7f13\u5b58\u540d\u79f0\u4e0d\u80fd\u4e3aNULL";
    private static final int shortExpireTime = 7;
    private final CacheOperationExpressionEvaluator evaluator = new CacheOperationExpressionEvaluator();
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private SaaSConfig saaSConfig;
    @Autowired(required=false)
    private KeyGenerator keyGenerator = new SimpleKeyGenerator();

    @Pointcut(value="@annotation(com.artfess.base.cache.annotation.Cacheable)")
    public void cacheablePointcut() {
    }

    @Pointcut(value="@annotation(com.artfess.base.cache.annotation.CacheEvict)")
    public void cacheEvictPointcut() {
    }

    @Pointcut(value="@annotation(com.artfess.base.cache.annotation.CachePut)")
    public void cachePutPointcut() {
    }

    @Around(value="cacheablePointcut()")
    public Object cacheablePointcut(ProceedingJoinPoint joinPoint) throws Throwable {
        CacheOperationInvoker aopAllianceInvoker = this.getCacheOperationInvoker(joinPoint);
        Method method = this.getSpecificmethod(joinPoint);
        Cacheable cacheable = (Cacheable)AnnotationUtils.findAnnotation((Method)method, Cacheable.class);
        try {
            return this.executeCacheable(aopAllianceInvoker, cacheable, method, joinPoint.getArgs(), joinPoint.getTarget());
        }
        catch (SerializationException e) {
            String[] cacheNames = cacheable.cacheNames();
            this.delete(cacheNames, cacheable.key(), cacheable.pureKey(), method, joinPoint.getArgs(), joinPoint.getTarget());
            if (cacheable.ignoreException()) {
                this.logger.warn(e.getMessage(), (Throwable)e);
                return aopAllianceInvoker.invoke();
            }
            throw e;
        }
        catch (Exception e) {
            if (cacheable.ignoreException()) {
                this.logger.warn(e.getMessage(), (Throwable)e);
                return aopAllianceInvoker.invoke();
            }
            throw e;
        }
    }

    @Around(value="cacheEvictPointcut()")
    public Object cacheEvictPointcut(ProceedingJoinPoint joinPoint) throws Throwable {
        CacheOperationInvoker aopAllianceInvoker = this.getCacheOperationInvoker(joinPoint);
        Method method = this.getSpecificmethod(joinPoint);
        CacheEvict cacheEvict = (CacheEvict)AnnotationUtils.findAnnotation((Method)method, CacheEvict.class);
        try {
            return this.executeEvict(aopAllianceInvoker, cacheEvict, method, joinPoint.getArgs(), joinPoint.getTarget());
        }
        catch (Exception e) {
            if (cacheEvict.ignoreException()) {
                this.logger.warn(e.getMessage(), (Throwable)e);
                return aopAllianceInvoker.invoke();
            }
            throw e;
        }
    }

    @Around(value="cachePutPointcut()")
    public Object cachePutPointcut(ProceedingJoinPoint joinPoint) throws Throwable {
        CacheOperationInvoker aopAllianceInvoker = this.getCacheOperationInvoker(joinPoint);
        Method method = this.getSpecificmethod(joinPoint);
        CachePut cacheEvict = (CachePut)AnnotationUtils.findAnnotation((Method)method, CachePut.class);
        try {
            return this.executePut(aopAllianceInvoker, cacheEvict, method, joinPoint.getArgs(), joinPoint.getTarget());
        }
        catch (Exception e) {
            if (cacheEvict.ignoreException()) {
                this.logger.warn(e.getMessage(), (Throwable)e);
                return aopAllianceInvoker.invoke();
            }
            throw e;
        }
    }

    private CacheSetting buildCacheSetting(Cacheable cacheable, CachePut cachePut, String depict, Method method, Object[] args, Object target) {
        boolean shortExpire;
        FirstCache firstCache = cacheable == null ? cachePut.firstCache() : cacheable.firstCache();
        SecondaryCache secondaryCache = cacheable == null ? cachePut.secondaryCache() : cacheable.secondaryCache();
        int firstCacheExpireTime = 0;
        int secondaryCacheExpireTime = 0;
        TimeUnit firstExpireTimeUnit = TimeUnit.SECONDS;
        TimeUnit secondaryExpireTimeUnit = TimeUnit.SECONDS;
        boolean bl = shortExpire = cacheable == null ? cachePut.shortExpire() : cacheable.shortExpire();
        if (shortExpire) {
            firstCacheExpireTime = 7;
        } else {
            firstCacheExpireTime = this.getFirstCacheExpireTime(firstCache, method, args, target);
            secondaryCacheExpireTime = this.getSecondaryCacheExpireTime(secondaryCache, method, args, target);
            firstExpireTimeUnit = firstCache.timeUnit();
            secondaryExpireTimeUnit = secondaryCache.timeUnit();
        }
        FirstCacheSetting firstCacheSetting = new FirstCacheSetting(firstCache.initialCapacity(), firstCache.maximumSize(), firstCacheExpireTime, firstExpireTimeUnit, firstCache.expireMode());
        SecondaryCacheSetting secondaryCacheSetting = new SecondaryCacheSetting(secondaryCacheExpireTime, secondaryCache.preloadTime(), secondaryExpireTimeUnit, secondaryCache.forceRefresh(), secondaryCache.isAllowNullValue(), secondaryCache.magnification());
        return new CacheSetting(firstCacheSetting, secondaryCacheSetting, depict);
    }

    private Object executeCacheable(CacheOperationInvoker invoker, Cacheable cacheable, Method method, Object[] args, Object target) {
        String[] cacheNames = cacheable.cacheNames();
        Assert.notEmpty((Object[])cacheable.cacheNames(), (String)CACHE_NAME_ERROR_MESSAGE);
        String cacheName = cacheNames[0];
        Object key = cacheable.key();
        if (!cacheable.pureKey()) {
            key = this.generateKey(cacheable.key(), method, args, target);
        }
        Assert.notNull((Object)key, (String)String.format(CACHE_KEY_ERROR_MESSAGE, cacheable.key()));
        CacheSetting cacheSetting = this.buildCacheSetting(cacheable, null, cacheable.depict(), method, args, target);
        ICache cache = this.cacheManager.getCache(cacheName, cacheSetting);
        return cache.get(key, () -> invoker.invoke());
    }

    private Object executeEvict(CacheOperationInvoker invoker, CacheEvict cacheEvict, Method method, Object[] args, Object target) {
        String[] cacheNames = cacheEvict.cacheNames();
        Assert.notEmpty((Object[])cacheEvict.cacheNames(), (String)CACHE_NAME_ERROR_MESSAGE);
        if (cacheEvict.allEntries()) {
            for (String cacheName : cacheNames) {
                Collection<ICache> caches = this.cacheManager.getCache(cacheName);
                if (CollectionUtils.isEmpty(caches)) {
                    ICache cache = this.cacheManager.getCache(cacheName, new CacheSetting(new FirstCacheSetting(), new SecondaryCacheSetting(), "\u9ed8\u8ba4\u7f13\u5b58\u914d\u7f6e\uff08\u6e05\u9664\u65f6\u751f\u6210\uff09"));
                    cache.clear();
                    continue;
                }
                for (ICache cache : caches) {
                    cache.clear();
                }
            }
        } else {
            this.delete(cacheNames, cacheEvict.key(), cacheEvict.pureKey(), method, args, target);
        }
        return invoker.invoke();
    }

    private void delete(String[] cacheNames, String keySpEL, boolean pureKey, Method method, Object[] args, Object target) {
        Object key = keySpEL;
        if (!pureKey) {
            key = this.generateKey(keySpEL, method, args, target);
        }
        Assert.notNull((Object)key, (String)String.format(CACHE_KEY_ERROR_MESSAGE, keySpEL));
        for (String cacheName : cacheNames) {
            Collection<ICache> caches = this.cacheManager.getCache(cacheName);
            if (CollectionUtils.isEmpty(caches)) {
                ICache cache = this.cacheManager.getCache(cacheName, new CacheSetting(new FirstCacheSetting(), new SecondaryCacheSetting(), "\u9ed8\u8ba4\u7f13\u5b58\u914d\u7f6e\uff08\u5220\u9664\u65f6\u751f\u6210\uff09"));
                cache.evict(key);
                continue;
            }
            for (ICache cache : caches) {
                cache.evict(key);
            }
        }
    }

    private Object executePut(CacheOperationInvoker invoker, CachePut cachePut, Method method, Object[] args, Object target) {
        String[] cacheNames = cachePut.cacheNames();
        Assert.notEmpty((Object[])cachePut.cacheNames(), (String)CACHE_NAME_ERROR_MESSAGE);
        Object key = cachePut.key();
        if (!cachePut.pureKey()) {
            key = this.generateKey(cachePut.key(), method, args, target);
        }
        Assert.notNull((Object)key, (String)String.format(CACHE_KEY_ERROR_MESSAGE, cachePut.key()));
        CacheSetting cacheSetting = this.buildCacheSetting(null, cachePut, cachePut.depict(), method, args, target);
        Object result = invoker.invoke();
        for (String cacheName : cacheNames) {
            ICache cache = this.cacheManager.getCache(cacheName, cacheSetting);
            cache.put(key, result);
        }
        return result;
    }

    private CacheOperationInvoker getCacheOperationInvoker(ProceedingJoinPoint joinPoint) {
        return () -> {
            try {
                return joinPoint.proceed();
            }
            catch (Throwable ex) {
                throw new CacheOperationInvoker.ThrowableWrapperException(ex);
            }
        };
    }

    private Object generateKey(String keySpEl, Method method, Object[] args, Object target) {
        EvaluationContext evaluationContext;
        AnnotatedElementKey methodCacheKey;
        Object keyValue;
        Class<?> targetClass = this.getTargetClass(target);
        Object key = null;
        key = StringUtils.hasText((String)keySpEl) ? (Objects.isNull(keyValue = this.evaluator.key(keySpEl, methodCacheKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass), evaluationContext = this.evaluator.createEvaluationContext(method, args, target, targetClass, CacheOperationExpressionEvaluator.NO_RESULT))) ? "null" : keyValue) : this.keyGenerator.generate(target, method, args);
        String tenantId = this.baseContext.getCurrentTenantId();
        if (this.saaSConfig.isEnable() && StringUtil.isNotEmpty(tenantId)) {
            return key.toString() + "_" + tenantId;
        }
        return key.toString();
    }

    private int getFirstCacheExpireTime(FirstCache firstCache, Method method, Object[] args, Object target) {
        if (firstCache == null) {
            return 0;
        }
        int expireTime = firstCache.expireTime();
        Object expireTimeByExp = this.generateExpireTime(firstCache.expireTimeExp(), method, args, target);
        if (BeanUtils.isNotEmpty(expireTimeByExp)) {
            if (expireTimeByExp instanceof String) {
                try {
                    int parseInt = Integer.parseInt((String)expireTimeByExp);
                    if (parseInt > -1) {
                        expireTime = parseInt;
                    }
                }
                catch (Exception ex) {
                    this.logger.warn("\u89e3\u6790\u65b9\u6cd5\uff1a{}\u4e0a\u7684expireTimeExp\uff1a{}\u65f6\u51fa\u9519\u4e86", (Object)method.getName(), (Object)firstCache.expireTimeExp());
                }
            } else if (expireTimeByExp instanceof Integer) {
                expireTime = (Integer)expireTimeByExp;
            }
        }
        return expireTime;
    }

    private int getSecondaryCacheExpireTime(SecondaryCache secondaryCache, Method method, Object[] args, Object target) {
        if (secondaryCache == null) {
            return 0;
        }
        int expireTime = secondaryCache.expireTime();
        Object expireTimeByExp = this.generateExpireTime(secondaryCache.expireTimeExp(), method, args, target);
        if (BeanUtils.isNotEmpty(expireTimeByExp)) {
            if (expireTimeByExp instanceof String) {
                try {
                    int parseInt = Integer.parseInt((String)expireTimeByExp);
                    if (parseInt > -1) {
                        expireTime = parseInt;
                    }
                }
                catch (Exception ex) {
                    this.logger.warn("\u89e3\u6790\u65b9\u6cd5\uff1a{}\u4e0a\u7684expireTimeExp\uff1a{}\u65f6\u51fa\u9519\u4e86", (Object)method.getName(), (Object)secondaryCache.expireTimeExp());
                }
            } else if (expireTimeByExp instanceof Integer) {
                expireTime = (Integer)expireTimeByExp;
            }
        }
        return expireTime;
    }

    private Object generateExpireTime(String expireTimeExp, Method method, Object[] args, Object target) {
        Class<?> targetClass = this.getTargetClass(target);
        if (StringUtils.hasText((String)expireTimeExp)) {
            AnnotatedElementKey methodCacheKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
            EvaluationContext evaluationContext = this.evaluator.createEvaluationContext(method, args, target, targetClass, CacheOperationExpressionEvaluator.NO_RESULT);
            Object keyValue = this.evaluator.key(expireTimeExp, methodCacheKey, evaluationContext);
            return Objects.isNull(keyValue) ? "null" : keyValue;
        }
        return null;
    }

    private Class<?> getTargetClass(Object target) {
        Class<?> targetClass = AopProxyUtils.ultimateTargetClass((Object)target);
        if (targetClass == null) {
            targetClass = target.getClass();
        }
        return targetClass;
    }

    private Method getSpecificmethod(ProceedingJoinPoint pjp) {
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> targetClass = AopProxyUtils.ultimateTargetClass((Object)pjp.getTarget());
        if (targetClass == null && pjp.getTarget() != null) {
            targetClass = pjp.getTarget().getClass();
        }
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
        specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
        return specificMethod;
    }
}

