/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.manager;

import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FieldConvertUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.springframework.util.Assert;

public interface QueryFilterHelper<T> {
    public static final String INJECTION_REGEX = "[A-Za-z0-9\\_\\-\\+\\.]+";
    public static final String WHERE_SQL_TAG = "whereSql";
    public static final String ORDER_SQL_TAG = "orderBySql";

    default public IPage<T> convert2IPage(PageBean pageBean) {
        return pageBean == null ? new Page() : new Page((long)pageBean.getPage().intValue(), (long)pageBean.getPageSize().intValue(), pageBean.showTotal());
    }

    default public void addConditionToWapper(String group, Map<String, String> groupTree, QueryWrapper<T> queryWrapper, Map<String, List<QueryField>> groupQueryField, Class<T> currentModelClass) {
        List<QueryField> fields = groupQueryField.get(group);
        if (BeanUtils.isNotEmpty(fields)) {
            fields.forEach(l -> this.convertQueryField(queryWrapper, (QueryField)l, currentModelClass));
            FieldRelation groupRelation = fields.get(0).getRelation();
            if (FieldRelation.OR.equals((Object)groupRelation)) {
                queryWrapper.or();
            }
            groupTree.forEach((groupChild, parentGroup) -> {
                if (StringUtil.isNotEmpty(parentGroup) && parentGroup.equals(group)) {
                    queryWrapper.nested(BeanUtils.isNotEmpty(groupQueryField.get(groupChild)), w -> this.addConditionToWapper((String)groupChild, groupTree, (QueryWrapper<T>)w, groupQueryField, currentModelClass));
                }
            });
        }
    }

    default public QueryWrapper<T> convert2Wrapper(QueryFilter<?> queryFilter, Class<T> currentModelClass) {
        QueryWrapper queryWrapper = new QueryWrapper();
        Map<String, List<QueryField>> groupQueryField = queryFilter.groupQueryField();
        Map<String, String> groupTree = queryFilter.getGroupTree();
        List<String> roots = queryFilter.getRootGroup(groupTree);
        FieldRelation groupRelation = queryFilter.getGroupRelation();
        roots.forEach(group -> {
            if (FieldRelation.OR.equals((Object)groupRelation)) {
                queryWrapper.or();
            }
            List fields = null == groupQueryField.get(group) ? new ArrayList() : (List)groupQueryField.get(group);
            ListIterator i = fields.listIterator();
            while (i.hasNext()) {
                QueryField field = (QueryField)i.next();
                if (!StringUtil.isEmpty(field.getProperty()) && !BeanUtils.isEmpty(field.getValue())) continue;
                i.remove();
            }
            queryWrapper.nested(BeanUtils.isNotEmpty(fields), w -> this.addConditionToWapper((String)group, groupTree, (QueryWrapper<T>)w, groupQueryField, currentModelClass));
        });
        Map<Direction, List<FieldSort>> groupFieldSort = queryFilter.groupFieldSort();
        groupFieldSort.forEach((d, l) -> {
            ListIterator i = l.listIterator();
            while (i.hasNext()) {
                if (!StringUtil.isEmpty(((FieldSort)i.next()).getProperty())) continue;
                i.remove();
            }
            if (Direction.DESC.equals(d)) {
                queryWrapper.orderByDesc((Object[])this.convertSortFieldList((List<FieldSort>)l, currentModelClass));
            } else {
                queryWrapper.orderByAsc((Object[])this.convertSortFieldList((List<FieldSort>)l, currentModelClass));
            }
        });
        Map<String, Object> params = queryFilter.getParams();
        if (params != null && params.size() > 0) {
            Map paramNameValuePairs = queryWrapper.getParamNameValuePairs();
            paramNameValuePairs.putAll(params);
        }
        return queryWrapper;
    }

    default public String[] convertSortFieldList(List<FieldSort> list, Class<T> currentModelClass) {
        if (list == null) {
            return null;
        }
        String[] ary = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ary[i] = currentModelClass != null ? FieldConvertUtil.property2Field(list.get(i).getProperty(), currentModelClass) : list.get(i).getProperty();
        }
        return ary;
    }

    default public void convertQueryField(QueryWrapper<T> queryWrapper, QueryField queryField, Class<T> currentModelClass) {
        FieldRelation r = queryField.getRelation();
        if (FieldRelation.OR.equals((Object)r)) {
            queryWrapper.or();
        }
        String field = queryField.getProperty();
        if (currentModelClass != null) {
            field = FieldConvertUtil.property2Field(field, currentModelClass);
        }
        QueryOP operation = queryField.getOperation();
        switch (operation) {
            case EQUAL: 
            case EQUAL_IGNORE_CASE: {
                queryWrapper.eq((Object)field, queryField.getValue());
                break;
            }
            case NOT_EQUAL: {
                queryWrapper.ne((Object)field, queryField.getValue());
                break;
            }
            case LESS: {
                queryWrapper.lt((Object)field, queryField.getValue());
                break;
            }
            case GREAT: {
                queryWrapper.gt((Object)field, queryField.getValue());
                break;
            }
            case LESS_EQUAL: {
                queryWrapper.le((Object)field, queryField.getValue());
                break;
            }
            case GREAT_EQUAL: {
                queryWrapper.ge((Object)field, queryField.getValue());
                break;
            }
            case LIKE: {
                queryWrapper.like((Object)field, queryField.getValue());
                break;
            }
            case LEFT_LIKE: {
                queryWrapper.likeLeft((Object)field, queryField.getValue());
                break;
            }
            case RIGHT_LIKE: {
                queryWrapper.likeRight((Object)field, queryField.getValue());
                break;
            }
            case IS_NULL: {
                queryWrapper.isNull((Object)field);
                break;
            }
            case NOTNULL: {
                queryWrapper.isNotNull((Object)field);
                break;
            }
            case IN: {
                queryWrapper.in((Object)field, this.convert2ObjectArray(queryField.getValue()));
                break;
            }
            case NOT_IN: {
                queryWrapper.notIn((Object)field, this.convert2ObjectArray(queryField.getValue()));
                break;
            }
            case BETWEEN: {
                Object[] objs = this.convert2ObjectArray(queryField.getValue());
                Assert.notNull((Object)objs, (String)String.format("\u67e5\u8be2\u6761\u4ef6\uff1a%s\u7684\u67e5\u8be2\u503c\u4e3a\u7a7a", field));
                Assert.isTrue((objs.length == 2 ? 1 : 0) != 0, (String)String.format("\u67e5\u8be2\u6761\u4ef6\u4e3abetween\u65f6\uff0c\u67e5\u8be2\u503c\u5fc5\u987b\u4e3a\u4e24\u4e2a\uff0c\u4f46\u662f\u4f20\u5165\u7684\u67e5\u8be2\u503c\u4e3a\uff1a%s", objs));
                String dbType = SQLUtil.getDbType();
                if ("oracle".equals(dbType) || "postgresql".equals(dbType)) {
                    Date[] dates = new Date[2];
                    if (objs[0] instanceof String) {
                        dates[0] = this.convertStringToDate(String.valueOf(objs[0]), DateUtil.isRqFormat(String.valueOf(objs[0])) ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss");
                    }
                    if (objs[1] instanceof String) {
                        dates[1] = this.convertStringToDate(String.valueOf(objs[1]), DateUtil.isRqFormat(String.valueOf(objs[1])) ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss");
                    }
                    queryWrapper.between((Object)field, BeanUtils.isNotEmpty(dates[0]) ? dates[0] : objs[0], BeanUtils.isNotEmpty(dates[1]) ? dates[1] : objs[1]);
                    break;
                }
                queryWrapper.between((Object)field, objs[0], objs[1]);
            }
        }
    }

    default public Date convertStringToDate(String str, String type) {
        SimpleDateFormat dd = new SimpleDateFormat(type);
        Date result = null;
        try {
            result = dd.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    default public Object[] convert2ObjectArray(Object obj) {
        if (BeanUtils.isEmpty(obj)) {
            return new Object[]{"''"};
        }
        if (obj instanceof String) {
            String str = obj.toString();
            Object[] split = str.split(",");
            for (int i = 0; i < split.length; ++i) {
                split[i] = this.handleQuotation((String)split[i]);
            }
            return split;
        }
        if (obj instanceof List) {
            List objList = (List)obj;
            return objList.toArray();
        }
        if (obj instanceof Object[]) {
            return (Object[])obj;
        }
        if (obj instanceof Object) {
            return new Object[]{obj};
        }
        return null;
    }

    default public String handleQuotation(String str) {
        String ResultString = str;
        try {
            Pattern regex = Pattern.compile("^'(.*)'$");
            Matcher regexMatcher = regex.matcher(str);
            if (regexMatcher.find()) {
                ResultString = regexMatcher.group(1);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return ResultString;
    }

    default public void copyQuerysInParams(QueryFilter queryFilter) {
        List<QueryField> querys = queryFilter.getQuerys();
        Map<String, Object> params = queryFilter.getParams();
        if (BeanUtils.isNotEmpty(querys)) {
            querys.forEach(i -> {
                if (!params.containsKey(i.getProperty())) {
                    params.put(i.getProperty(), i.getValue());
                }
            });
        }
    }
}

