/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.controller;

import com.artfess.application.model.AppModel;
import com.artfess.application.params.AppTree;
import com.artfess.application.persistence.manager.AppModelManager;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.sysConfig.persistence.manager.SysAuthUserManager;
import com.artfess.sysConfig.persistence.manager.SysCategoryManager;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.SysCategory;
import com.artfess.sysConfig.persistence.model.SysType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/appModel/v1"})
@Api(tags={"\u79fb\u52a8\u7aef\u5e94\u7528"})
@ApiGroup(group={"group_application"})
public class AppModelController
extends BaseController<AppModelManager, AppModel> {
    @Resource
    AppModelManager appModelManager;
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    SysCategoryManager sysCategoryManager;
    @Resource
    SysAuthUserManager sysAuthUserManager;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u79fb\u52a8\u7aef\u5e94\u7528\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u79fb\u52a8\u7aef\u5e94\u7528\u5217\u8868")
    public PageList<AppModel> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<AppModel> queryFilter) throws Exception {
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("ID_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return this.appModelManager.query(queryFilter);
    }

    @RequestMapping(value={"getApp"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6App", httpMethod="GET", notes="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6App")
    public List<AppTree> getApp(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        SysCategory sysCategory = this.sysCategoryManager.getByTypeKey(typeKey);
        ArrayList<AppTree> appTrees = new ArrayList<AppTree>();
        if (BeanUtils.isEmpty((Object)sysCategory)) {
            return appTrees;
        }
        List list = this.sysTypeManager.getByGroupKey(sysCategory.getGroupKey());
        List newList = this.sysAuthUserManager.getAuthItems(list, SysType::getId);
        List<String> authList = newList.stream().map(SysType::getId).collect(Collectors.toList());
        for (SysType sysType : list) {
            List appList = this.appModelManager.getByTypeId(sysType.getId());
            appList = this.sysAuthUserManager.getAuthItems(appList, AppModel::getId);
            AppTree appItem = new AppTree();
            appItem.setTypeId(sysType.getId());
            appItem.setTypeName(sysType.getName());
            appItem.setPid(sysType.getParentId());
            appItem.setAppList(appList);
            appTrees.add(appItem);
        }
        List<AppTree> rtnList = BeanUtils.listToTree(appTrees);
        rtnList = this.traversalTree(rtnList, authList, false);
        return rtnList;
    }

    private List<AppTree> traversalTree(List<AppTree> appTrees, List<String> authList, boolean isShow) {
        ArrayList<AppTree> trees = new ArrayList<AppTree>();
        for (AppTree tree : appTrees) {
            if (authList.contains(tree.getId())) {
                List<AppTree> children = this.traversalTree(tree.getChildren(), authList, true);
                tree.setChildren(children);
                trees.add(tree);
                continue;
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"authorize_id_", (Object)tree.getId());
            wrapper.eq((Object)"obj_type_", (Object)"app");
            if (this.sysAuthUserManager.count((Wrapper)wrapper) > 0 || !isShow) continue;
            List<AppTree> children = this.traversalTree(tree.getChildren(), authList, true);
            tree.setChildren(children);
            trees.add(tree);
        }
        return trees;
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u79fb\u52a8\u7aef\u5e94\u7528\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u79fb\u52a8\u7aef\u5e94\u7528\u6570\u636e\u8be6\u60c5")
    public AppModel get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (AppModel)this.appModelManager.get((Serializable)((Object)id));
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u79fb\u52a8\u7aef\u5e94\u7528\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u79fb\u52a8\u7aef\u5e94\u7528\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="appModel", value="\u79fb\u52a8\u7aef\u5e94\u7528\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody AppModel appModel) throws Exception {
        String msg = "\u6dfb\u52a0\u79fb\u52a8\u7aef\u5e94\u7528\u6210\u529f";
        if (StringUtil.isEmpty((String)appModel.getId())) {
            this.appModelManager.create((Model)appModel);
        } else {
            this.appModelManager.update((Model)appModel);
            msg = "\u66f4\u65b0\u79fb\u52a8\u7aef\u5e94\u7528\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @GetMapping(value={"updateEnable/{id}"})
    @ApiOperation(value="\u66f4\u6539\u5e94\u7528\u4e2d\u5fc3\u72b6\u6001", httpMethod="POST", notes="\u66f4\u6539\u5e94\u7528\u4e2d\u5fc3\u72b6\u6001")
    public CommonResult<String> updateEnable(@PathVariable(value="id") String id) {
        AppModel appModel = (AppModel)this.appModelManager.get((Serializable)((Object)id));
        if (BeanUtils.isEmpty((Object)((Object)appModel))) {
            return new CommonResult(false, "\u6839\u636eID\u65e0\u6cd5\u67e5\u8be2\u5230\u5e94\u7528\u4e2d\u5fc3");
        }
        if (appModel.getEnable().equals(0)) {
            appModel.setEnable(1);
        } else {
            appModel.setEnable(0);
        }
        this.appModelManager.update((Model)appModel);
        return new CommonResult(true, "\u72b6\u6001\u4fee\u6539\u6210\u529f");
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u79fb\u52a8\u7aef\u5e94\u7528\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u79fb\u52a8\u7aef\u5e94\u7528\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.appModelManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"exportXml"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u79fb\u52a8\u7aef\u5e94\u7528xml", httpMethod="GET", notes="\u5bfc\u51fa\u79fb\u52a8\u7aef\u5e94\u7528xml")
    public void exportXml(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="ids", value="\u79fb\u52a8\u7aef\u5e94\u7528id", required=true) @RequestParam String ids) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)ids)) {
            String[] stringsIds = ids.split(",");
            List<String> list = Arrays.asList(stringsIds);
            String zipName = "ht_appModel_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmmss");
            Map<String, String> strXml = ((AppModelManager)this.baseService).exportData(list);
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, strXml, (String)zipName);
        }
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u79fb\u52a8\u7aef\u5e94\u7528\u5bfc\u5165", httpMethod="POST", notes="\u79fb\u52a8\u7aef\u5e94\u7528\u5bfc\u5165")
    public CommonResult<String> importData(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String msg;
            CommonResult message = new CommonResult("\u5bfc\u5165\u6210\u529f");
            ((AppModelManager)this.baseService).importData(request.getFile("file"));
            LinkedHashSet appModelsSaved = ThreadMsgUtil.getMapMsg2((String)"appModelsSaved");
            LinkedHashSet appModelsSkipped = ThreadMsgUtil.getMapMsg2((String)"appModelsSkipped");
            StringBuilder sb = new StringBuilder();
            if (BeanUtils.isNotEmpty((Object)appModelsSkipped)) {
                sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u79fb\u52a8\u7aef\u5e94\u7528\u5df2\u5b58\u5728\u6545\u8df3\u8fc7\uff1a</div>");
                msg = String.format("%s", String.join((CharSequence)"", appModelsSkipped));
                sb.append(msg);
            }
            if (StringUtil.isNotEmpty((String)(msg = sb.toString()))) {
                message.setMessage(msg);
            }
            return message;
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

