/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.mdm.uc.manager.impl;

import com.alibaba.druid.util.StringUtils;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.mdm.uc.dao.MdmOrgBasicDao;
import com.artfess.mdm.uc.manager.MdmOrgBasicManager;
import com.artfess.mdm.uc.manager.MdmOrgDemensionManager;
import com.artfess.mdm.uc.model.MdmOrgBasic;
import com.artfess.mdm.uc.model.MdmOrgDemension;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@DS(value="mdm")
@Transactional(rollbackFor={Exception.class})
public class MdmOrgBasicManagerImpl
extends BaseManagerImpl<MdmOrgBasicDao, MdmOrgBasic>
implements MdmOrgBasicManager {
    static List<MdmOrgBasic> childOrg = new ArrayList<MdmOrgBasic>();
    @Autowired
    MdmOrgDemensionManager demensionService;

    @Override
    public boolean insertObj(MdmOrgBasic org) {
        if (StringUtil.isEmpty((String)org.getName())) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u540d\u79f0\u3010name\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isEmpty((String)org.getCode())) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801\u3010code\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (org.getCode().contains(",")) {
            throw new RuntimeException("\u7ec4\u7ec7\u7f16\u7801\u4e2d\u4e0d\u80fd\u5305\u542b\u82f1\u6587\u9017\u53f7\u2018,\u2019");
        }
        if (StringUtil.isEmpty((String)org.getDemId())) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ef4\u5ea6id\u3010demId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (this.getCountByCode(org.getId(), org.getCode(), org.getOrgVersion()) > 0) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801[" + org.getCode() + "]\u5df2\u5b58\u5728\uff01");
        }
        MdmOrgDemension dem = this.demensionService.getObjById(org.getDemId());
        if (BeanUtils.isEmpty((Object)((Object)dem))) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684demId[" + org.getDemId() + "]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4fe1\u606f\uff01");
        }
        MdmOrgBasic pOrg = null;
        if (!"0".equals(org.getParentId()) && StringUtil.isNotEmpty((String)org.getParentId())) {
            pOrg = this.getObjById(org.getParentId());
            if (BeanUtils.isEmpty((Object)((Object)pOrg))) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684parentId[" + org.getParentId() + "]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
            }
            if (BeanUtils.isEmpty((Object)((Object)pOrg)) && !pOrg.getDemId().equals(org.getDemId())) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165demId\u4e0e\u6240\u8f93\u5165\u7684\u7236\u7ec4\u7ec7\u6240\u5bf9\u5e94\u7684\u7ef4\u5ea6id\u4e0d\u4e00\u81f4\uff01");
            }
            if (BeanUtils.isEmpty((Object)((Object)pOrg)) && pOrg.getOrgVersion() != org.getOrgVersion()) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7248\u672c\u53f7\u4e0e\u6240\u8f93\u5165\u7684\u7236\u7ec4\u7ec7\u6240\u5bf9\u5e94\u7684\u7248\u672c\u53f7\u4e0d\u4e00\u81f4\uff01");
            }
            String orgKind = org.getOrgKind();
            if (StringUtil.isEmpty((String)orgKind)) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u7ec4\u7ec7\u7c7b\u578b\uff01");
            }
            if (!orgKind.equals("dept") && pOrg.getOrgKind().equals("dept")) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u8be5\u7ec4\u7ec7\u7684\u7236\u7ea7\u7c7b\u578b\u662f\u3010\u90e8\u95e8\u3011\uff0c\u8be5\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u3010\u673a\u6784\u3011\uff01");
            }
        }
        org.setId(UniqueIdUtil.getSuid());
        if (StringUtils.isEmpty((CharSequence)org.getParentId())) {
            org.setParentId("0");
        }
        if (BeanUtils.isEmpty((Object)((Object)pOrg))) {
            org.setLevel(1);
            org.setPathId("/" + org.getDemId() + "/" + org.getId());
            org.setPathName("/" + org.getName());
            org.setPathCode("/" + org.getCode());
            if (org.getOrgVersion() == null) {
                Integer orgVersion = this.getMaxOrgVersion();
                if (orgVersion == 0) {
                    orgVersion = Integer.parseInt(LocalDate.now().getYear() + "01");
                } else {
                    String orgVersionStr = String.valueOf(orgVersion);
                    if (orgVersionStr.length() > 4) {
                        int year = Integer.parseInt(orgVersionStr.substring(0, 3));
                        orgVersion = year != LocalDate.now().getYear() ? Integer.valueOf(Integer.parseInt(LocalDate.now().getYear() + "01")) : Integer.valueOf(orgVersion + 1);
                    }
                }
                org.setOrgVersion(orgVersion);
            }
            if (org.getOrgStartDate() == null) {
                org.setOrgStartDate(LocalDate.now());
            }
            org.setOrgEndDate(LocalDate.of(9999, 12, 31));
        } else {
            org.setLevel(pOrg.getLevel() + 1);
            org.setPathId(pOrg.getPathId() + "/" + org.getId());
            org.setPathName(pOrg.getPathName() + "/" + org.getName());
            org.setPathCode(pOrg.getPathCode() + "/" + org.getCode());
            org.setOrgVersion(pOrg.getOrgVersion());
            org.setOrgStartDate(pOrg.getOrgStartDate());
            org.setOrgEndDate(pOrg.getOrgEndDate());
        }
        if (org.getLimitNum() == null) {
            org.setLimitNum(0);
        }
        if (org.getExceedLimitNum() == null) {
            org.setExceedLimitNum(0);
        }
        org.setLastOperateTime(LocalDateTime.now());
        org.setLastTimeSeq(new Date().getTime());
        org.setIsDele("0");
        org.setSn(this.getNextSequenceByParentId(org.getParentId()));
        return this.save((Object)org);
    }

    @Override
    public boolean updateObj(MdmOrgBasic org) {
        int num;
        QueryWrapper queryWrapper;
        MdmOrgBasic oldOrg;
        if (StringUtil.isEmpty((String)org.getCode())) {
            throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        MdmOrgDemension dem = (MdmOrgDemension)this.demensionService.get((Serializable)((Object)org.getDemId()));
        if (StringUtil.isNotEmpty((String)org.getDemId()) && BeanUtils.isEmpty((Object)((Object)dem))) {
            throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684demId\u3010" + org.getDemId() + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4fe1\u606f\uff01");
        }
        MdmOrgBasic pOrg = null;
        if (StringUtil.isNotEmpty((String)org.getParentId()) && !"0".equals(org.getParentId())) {
            pOrg = this.getObjById(org.getParentId());
            if (BeanUtils.isEmpty((Object)((Object)pOrg))) {
                throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684parentId\u3010" + org.getDemId() + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
            }
            if (StringUtil.isNotEmpty((String)org.getDemId()) && BeanUtils.isNotEmpty((Object)((Object)pOrg)) && !pOrg.getDemId().equals(org.getDemId())) {
                throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165demId\u4e0e\u6240\u8f93\u5165\u7684\u7236\u7ec4\u7ec7\u6240\u5bf9\u5e94\u7684\u7ef4\u5ea6id\u4e0d\u4e00\u81f4\uff01");
            }
            if (BeanUtils.isEmpty((Object)((Object)pOrg)) && pOrg.getOrgVersion() != org.getOrgVersion()) {
                throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7248\u672c\u53f7\u4e0e\u6240\u8f93\u5165\u7684\u7236\u7ec4\u7ec7\u6240\u5bf9\u5e94\u7684\u7248\u672c\u53f7\u4e0d\u4e00\u81f4\uff01");
            }
        }
        if (BeanUtils.isEmpty((Object)((Object)(oldOrg = this.getObjById(org.getId()))))) {
            throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7ID\u9519\u8bef\uff01");
        }
        String orgKind = org.getOrgKind();
        if (orgKind.equals("ogn")) {
            queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"ORG_KIND_", (Object)"dept")).eq((Object)"ID_", (Object)org.getParentId());
            num = ((MdmOrgBasicDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
            if (num > 0) {
                throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u8be5\u7ec4\u7ec7\u7684\u7236\u7ea7\u662f\u90e8\u95e8\uff0c\u8be5\u7ec4\u7ec7\u4e0d\u80fd\u4fee\u6539\u4e3a\u673a\u6784\uff01");
            }
        }
        if (orgKind.equals("dept")) {
            queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"ORG_KIND_", (Object)"ogn")).eq((Object)"PARENT_ID_", (Object)org.getId());
            num = ((MdmOrgBasicDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
            if (num > 0) {
                throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u8be5\u7ec4\u7ec7\u4e0b\u5df2\u6709\u5b50\u7ec4\u7ec7\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539\u4e3a\u90e8\u95e8\uff01");
            }
        }
        if (BeanUtils.isEmpty((Object)((Object)pOrg))) {
            org.setLevel(1);
            org.setPathId("/" + org.getDemId() + "/" + org.getId());
            org.setPathName("/" + org.getName());
            org.setPathCode("/" + org.getCode());
        } else {
            org.setLevel(pOrg.getLevel() + 1);
            org.setPathId(pOrg.getPathId() + "/" + org.getId());
            org.setPathName(pOrg.getPathName() + "/" + org.getName());
            org.setPathCode(pOrg.getPathCode() + "/" + org.getCode());
        }
        org.setOrgVersion(oldOrg.getOrgVersion());
        org.setOrgStartDate(oldOrg.getOrgStartDate());
        org.setOrgEndDate(oldOrg.getOrgEndDate());
        if (org.getSn() == null) {
            org.setSn(oldOrg.getSn());
        }
        if (org.getLimitNum() == null) {
            org.setLimitNum(oldOrg.getLimitNum());
        }
        if (org.getExceedLimitNum() == null) {
            org.setExceedLimitNum(oldOrg.getExceedLimitNum());
        }
        if (StringUtil.isEmpty((String)org.getOrgType())) {
            org.setOrgType(oldOrg.getOrgType());
        }
        org.setIsDele("0");
        String extName = org.getPathName().substring(0, org.getPathName().indexOf("/" + org.getName()));
        String extCode = org.getPathCode().substring(0, org.getPathCode().indexOf("/" + org.getCode()));
        String extId = org.getPathId().substring(0, org.getPathId().indexOf("/" + org.getId()));
        org.setLastOperateTime(LocalDateTime.now());
        org.setLastTimeSeq(new Date().getTime());
        this.updateById((Object)org);
        String[] ids = new String[]{org.getId()};
        List<MdmOrgBasic> allList = this.getAllByVersion(org.getOrgVersion());
        ArrayList<MdmOrgBasic> cList = new ArrayList<MdmOrgBasic>();
        for (String id : ids) {
            MdmOrgBasicManagerImpl.getChild(allList, id, cList);
        }
        String[] childIds = new String[cList.size()];
        for (int i = cList.size() - 1; i >= 0; --i) {
            String id;
            childIds[i] = id = ((MdmOrgBasic)((Object)cList.get(i))).getId();
            MdmOrgBasic c = (MdmOrgBasic)this.get((Serializable)((Object)id));
            if (c.getParentId().equals(org.getId())) {
                c.setPathName(org.getPathName() + "/" + c.getName());
                c.setPathCode(org.getPathCode() + "/" + c.getCode());
                c.setPathId(org.getPathId() + "/" + c.getId());
            } else {
                String pName = org.getName();
                String pCode = org.getCode();
                String pId = org.getId();
                MdmOrgBasic po = this.getObjById(c.getParentId());
                String pathName = po.getPathName().substring(po.getPathName().indexOf("/" + pName)) + "/" + c.getName();
                String pathCode = po.getPathCode().substring(po.getPathCode().indexOf("/" + pCode)) + "/" + c.getCode();
                String pathId = po.getPathId().substring(po.getPathId().indexOf("/" + pId)) + "/" + c.getId();
                c.setPathName(extName + pathName);
                c.setPathCode(extCode + pathCode);
                c.setPathId(extId + pathId);
            }
            c.setDemId(org.getDemId());
            c.setLastOperateTime(LocalDateTime.now());
            c.setLastTimeSeq(new Date().getTime());
            this.updateById((Object)c);
        }
        return true;
    }

    @Override
    public boolean remove(String id) {
        MdmOrgBasic org = (MdmOrgBasic)((Object)this.getById((Serializable)((Object)id)));
        if (org == null) {
            throw new RuntimeException("\u5220\u9664\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684Id\u3010" + id + "\u3011\u9519\u8bef\uff01");
        }
        org.setLastOperateTime(LocalDateTime.now());
        org.setLastTimeSeq(new Date().getTime());
        this.updateById((Object)org);
        this.removeById((Serializable)((Object)id));
        List<MdmOrgBasic> allList = this.getAllByVersion(org.getOrgVersion());
        childOrg.removeAll(childOrg);
        MdmOrgBasicManagerImpl.treeOrgList(allList, id);
        ArrayList<String> childIds = new ArrayList<String>();
        for (int i = 0; i < childOrg.size(); ++i) {
            MdmOrgBasic child = childOrg.get(i);
            child.setLastOperateTime(LocalDateTime.now());
            child.setLastTimeSeq(new Date().getTime());
            childIds.add(child.getId());
        }
        this.updateBatchById(childOrg);
        return this.removeBatchById(childIds);
    }

    @Override
    public boolean removeBatchById(List<String> ids) {
        for (String id : ids) {
            this.remove(id);
        }
        return true;
    }

    @Override
    public MdmOrgBasic getObjById(String id) {
        Assert.hasText((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        return (MdmOrgBasic)((Object)this.getById((Serializable)((Object)id)));
    }

    @Override
    public List<MdmOrgBasic> getAllByVersion(Integer orgVersion) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(orgVersion != null, (Object)"ORG_VERSION_", (Object)orgVersion);
        List list = ((MdmOrgBasicDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        return list;
    }

    public static List<MdmOrgBasic> treeOrgList(List<MdmOrgBasic> orgList, String parentId) {
        for (MdmOrgBasic org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            MdmOrgBasicManagerImpl.treeOrgList(orgList, org.getId());
            childOrg.add(org);
        }
        return childOrg;
    }

    public static List<MdmOrgBasic> getChild(List<MdmOrgBasic> orgList, String parentId, List<MdmOrgBasic> rtnList) {
        for (MdmOrgBasic org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            MdmOrgBasicManagerImpl.getChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    private Integer getCountByCode(String id, String code, Integer orgVersion) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"CODE_", (Object)code);
        queryWrapper.eq(StringUtil.isNotEmpty((String)id), (Object)"ID_", (Object)id);
        queryWrapper.eq(BeanUtils.isNotEmpty((Object)orgVersion), (Object)"ORG_VERSION_", (Object)orgVersion);
        Integer count = ((MdmOrgBasicDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return count;
    }

    private Integer getMaxOrgVersion() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"COALESCE(max(ORG_VERSION_),0) \"orgVersion\""});
        queryWrapper.eq((Object)"ORG_END_DATE_", (Object)"9999-12-31");
        List resultList = ((MdmOrgBasicDao)this.baseMapper).selectMaps((Wrapper)queryWrapper);
        if (resultList != null && resultList.size() > 0) {
            int n;
            Map resultMap = (Map)resultList.get(0);
            Integer result = Integer.parseInt(resultMap.get("orgVersion").toString());
            if (result == null) {
                n = 0;
            } else {
                result = (int)result;
                n = result;
            }
            return n;
        }
        return 0;
    }
}

